/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.FullCanvas;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

class BowlingCanvas
extends FullCanvas
implements Runnable {
    protected static final int COLOR_YELLOW = 0xFFFF00;
    protected static final int COLOR_ORANGE = 16753152;
    protected static final int COLOR_RED = 0xFF0000;
    protected static final int COLOR_BROWN = 0x773300;
    protected static final int COLOR_SKY_BLUE = 9231100;
    protected static final int COLOR_WHITE = 0xFFFFFF;
    protected static final int COLOR_BLACK = 0;
    protected static final int COLOR_LIGHT_GRAY = 0xC0C0C0;
    protected static final int COLOR_GRAY = 0x808080;
    protected static final int COLOR_DARK_GRAY = 0x404040;
    protected static final int COLOR_BLUE = 255;
    protected static final int COLOR_LIGHT_BLUE = 0x8080FF;
    protected static final int COLOR_BACKGROUND = 9231100;
    protected static final int COLOR_NORMAL_BLOCK = 9231100;
    protected static final int COLOR_LIST_BG = 9231100;
    protected static final int COLOR_LIST_SHADOW = 0x404040;
    protected static final int COLOR_LIST_BORDER = 0;
    protected static final int COLOR_LIST_PANE = 0xFFFFFF;
    protected static final int COLOR_LIST_TEXT = 0;
    protected static final int COLOR_LIST_SELECTED = 0x8080FF;
    protected static final int COLOR_LIST_SELECTED_TEXT = -1;
    protected static final int RANKING_COUNT = 5;
    protected static final int HEADER_HEIGHT_MARGIN = 15;
    protected final int SCORE_BOARD_HEIGHT;
    protected final Font FONT_LARGE = Font.getFont((int)0, (int)0, (int)16);
    protected final Font FONT_MEDIUM = Font.getFont((int)0, (int)0, (int)0);
    protected final Font FONT_SMALL = Font.getFont((int)0, (int)0, (int)8);
    protected final Font FONT_SCORE_BOARD = this.FONT_MEDIUM;
    protected static final int SETTING_ITEMS_COUNT = 1;
    protected static final int MENU_ITEMS_COUNT = 6;
    public final int SCREEN_WIDTH;
    public final int SCREEN_HEIGHT;
    private Bowling midlet;
    private Thread thread;
    private int nCurrentIndex;
    protected static final String[] MENU_ITEMS = new String[]{"Play", "Instructions", "Score", "Settings", "About", "Quit"};
    protected static final String[] SWITCH_ITEMS = new String[]{"On", "Off"};
    protected static final String[] SETTING_ITEMS = new String[]{"Sound"};
    protected String[] arrInstructionsText;
    protected String[] arrDemoText;
    int nInstructionsLength;
    public static final int STATE_INIT = 0;
    public static final int STATE_OPERATOR = 1;
    public static final int STATE_COM2US = 2;
    public static final int STATE_TITLE = 3;
    public static final int STATE_MENU = 4;
    public static final int STATE_RUN = 5;
    public static final int STATE_SCORE = 6;
    public static final int STATE_ABOUT = 7;
    public static final int STATE_HELP = 8;
    public static final int STATE_SETUP = 9;
    public static final int STATE_EXIT = 10;
    public static final int STATE_PAUSE = 11;
    public static final int STATE_PREV = 12;
    public static final int STATE_GAMEOVER = 13;
    public static final int STATE_LOAD = 1000;
    public static final int STATE_TITLE_Q = 1002;
    protected int nState;
    protected int nPreviousState;
    protected int nSecondPreviousState;
    protected static final int KEY_OFF = 0;
    protected static final int KEY_PRESSED = 1;
    protected static final int KEY_RELEASED = 2;
    protected static final int KEY_REPEATED = 3;
    protected int nKeyCode;
    protected int nKeyState;
    protected final int VIEW_HEIGHT = 208 - this.FONT_MEDIUM.getHeight() - 1;
    protected String strLeftCommand;
    protected String strRightCommand;
    protected long lStopWatchStartTime;
    protected final int HEADER_HEIGHT = this.FONT_LARGE.getHeight() + 15;
    protected static final int IDB_OPERATOR = 0;
    protected static final int IDB_COM2US = 1;
    protected static final int IDB_BG = 2;
    protected static final int IDB_TITLE = 3;
    protected static final int IDB_COPYRIGHT = 4;
    protected static final int IDB_BG_CLOSEUP = 5;
    protected static final int IDB_BG_SCORE = 6;
    protected static final int IDB_CHARACTER = 7;
    protected static final int IDB_PIN_LARGE = 8;
    protected static final int IDB_PIN_SMALL = 9;
    protected static final int IDB_BALL = 10;
    protected static final int IDB_HOOK_POWER = 11;
    protected static final int IDB_POINTER = 12;
    protected static final int IDB_DIRECTION = 13;
    protected static final int IDB_STRIKE = 14;
    protected static final int IDB_SPARE = 15;
    protected static final int IDB_ETC = 16;
    protected static final int IDB_NUMBER = 17;
    protected static final int IDB_ABOUT = 18;
    protected static final int IDB_COUNT = 19;
    protected static final int IDS_TITLE = 0;
    protected static final int IDS_ENDING = 1;
    protected static final int IDS_STRIKE = 2;
    protected static final int IDS_HIT_PIN = 3;
    protected static final int IDS_COUNT = 4;
    private Image[] IMAGES = new Image[19];
    private static int[] SOUND_SIZES = new int[]{65, 78, 44, 34};
    private Sound[] SOUNDS = new Sound[4];
    private Sound currentSound;
    protected static final byte SETTING_ON = 0;
    protected static final byte SETTING_OFF = 1;
    protected RecordStore rsData;
    protected byte[] byGameSetting = new byte[4];
    protected int[] nHighScore = new int[5];
    protected int nScore;
    protected int nStage;
    protected int nLife;
    protected int nStageStored;
    private int nTitleAniSeq;
    private int nMenuIndex;
    private int nPauseIndex;
    private int nHelpIndex;
    protected int nSettingIndex;
    public static final int STATUS_PLAY_INIT = 0;
    public static final int STATUS_PLAY_START = 1;
    public static final int STATUS_PLAY_MOVE_CLEARBAR = 2;
    public static final int STATUS_PLAY_MOVE_CLEARBAR_1 = 3;
    public static final int STATUS_PLAY_CONTROL = 4;
    public static final int STATUS_PLAY_SET_BALLCOORDINATES = 5;
    public static final int STATUS_PLAY_ACT_CHARACTER = 6;
    public static final int STATUS_PLAY_ROLL_BALL = 7;
    public static final int STATUS_PLAY_CLOSEUP = 8;
    public static final int STATUS_PLAY_CLOSEUP_2 = 9;
    public static final int STATUS_PLAY_CLOSEUP_3 = 10;
    public static final int STATUS_PLAY_CLEARBAR = 11;
    public static final int STATUS_PLAY_CLEARBAR_2 = 12;
    public static final int STATUS_PLAY_CLEARBAR_3 = 13;
    public static final int STATUS_PLAY_CLEARBAR_4 = 14;
    public static final int STATUS_PLAY_CLEARBAR_5 = 15;
    public static final int STATUS_PLAY_SHOW_SCORE = 16;
    public static final int STATUS_PLAY_SHOW_RESULT = 17;
    public static final int STATUS_PLAY_TEST = 18;
    public static final int CHARACTER_NORMAL = 0;
    public static final int CHARACTER_MOVE = 1;
    public static final int CHARACTER_THROW = 2;
    public static final int CHARACTER_THROW_1 = 3;
    public static final int CHARACTER_THROW_2 = 4;
    public static final int CHARACTER_THROW_3 = 5;
    public static final int CHARACTER_STRIKE = 6;
    public static final int CHARACTER_STRIKE_1 = 7;
    public static final int CHARACTER_STRIKE_2 = 8;
    public static final int CHARACTER_SPARE = 9;
    public static final int CHARACTER_SPARE_1 = 10;
    public static final int CHARACTER_NOTHIT = 11;
    public static final int CHARACTER_NOTHIT_1 = 12;
    public static final int CONTROL_MOVE = 0;
    public static final int CONTROL_SET_HOOK = 1;
    public static final int CONTROL_SET_POWER = 2;
    private static final int FRAME_FIRST_Y = 165;
    private static final int LARGE_BALL_SIZE = 35;
    private final int MOVE_BALL_MINIUM_X;
    private final int MOVE_BALL_MAXIUM_X;
    private final int MOVE_BALL_GAP_X;
    final int CLEAR_BAR_X;
    final int CLEAR_BAR_Y;
    private static final int PIN_STAND = 0;
    private static final int PIN_REMOVED = 1;
    private static final int LARGE_FIRST_PIN_X = 87;
    private static final int LARGE_FIRST_PIN_Y = 26;
    private static final int LARGE_PIN_GAP_X = 14;
    private static final int LARGE_PIN_GAP_Y = 4;
    private static final int LARGE_PIN_WIDTH = 11;
    private static final int SMALL_FIRST_PIN_X = 88;
    private static final int SMALL_FIRST_PIN_Y = 23;
    private static final int SMALL_PIN_GAP_X = 4;
    private static final int SMALL_PIN_GAP_Y = 1;
    final int[] LARGE_PIN_X = new int[]{0, 87, 73, 101, 59, 87, 115, 45, 73, 101, 129};
    final int[] LARGE_PIN_Y = new int[]{0, 26, 22, 22, 18, 18, 18, 14, 14, 14, 14};
    final int[] SMALL_PIN_X = new int[]{0, 88, 84, 92, 80, 88, 96, 76, 84, 92, 100};
    final int[] SMALL_PIN_Y = new int[]{0, 23, 22, 22, 21, 21, 21, 20, 20, 20, 20};
    private static final int REMAIN_PINS_VIEWER_MARK_X = 146;
    private static final int REMAIN_PINS_VIEWER_MARK_Y = 50;
    private static final int REMAIN_PINS_VIEWER_MARK_GAP_X = 4;
    private static final int REMAIN_PINS_VIEWER_MARK_GAP_Y = 6;
    final int[] REMAIN_PINS_MARK_X = new int[]{0, 146, 142, 150, 138, 146, 154, 134, 142, 150, 158};
    final int[] REMAIN_PINS_MARK_Y = new int[]{0, 50, 44, 44, 38, 38, 38, 32, 32, 32, 32};
    final int CLOSEUP_GUTTER_X_LEFT;
    final int CLOSEUP_GUTTER_X_RIGHT;
    final int CLOSEUP_GUTTER_X_GAP;
    final int SCORE_BOX_Y;
    int nPlayStatus = 0;
    int nKeyFlag = 0;
    int nBallThrowCnt = 0;
    int nClearBarMoveY;
    int nControlStatus = 0;
    int nPowerMove = 0;
    int nPower = 0;
    int interv = 240;
    int nSpeed = 0;
    int nFrame = 0;
    int nHook = 0;
    boolean blnClearBarMoveEnd = false;
    boolean blnClearBarUp = false;
    int nMaintainIndex;
    int nMaximumIndex;
    long beginingTime;
    boolean blnPause;
    boolean blnEndFrame;
    private int idx = 0;
    private int nCloseupBallX = 0;
    private int nGutter = 0;
    int[] arrPin = new int[11];
    int[] select2Flag = new int[11];
    int[] tempFlag = new int[11];
    int[] temp2Flag = new int[11];
    int nCloseupFrame = 0;
    int[] mx = new int[11];
    int[] my = new int[11];
    int[] mmy = new int[11];
    int[] bm = new int[11];
    int[] prebm = new int[11];
    boolean pnS = false;
    int nPlayFrame = 0;
    int[] score1 = new int[11];
    int[] score2 = new int[11];
    int[] score3 = new int[11];
    int[] tscore = new int[11];
    int[] mscore = new int[11];
    int[] lscore = new int[11];
    int[] strike = new int[11];
    int[] spare = new int[11];
    int[][] moveBall = new int[22][2];
    int[] pRight = new int[22];
    int[] pLeft = new int[22];
    int[] pY = new int[22];
    private int spbX = 0;
    private int sbFlag = 0;
    private int nHookTemp = 4;
    private int nBallX = 89;
    private int bFlag = 0;
    private int gFlag = 1;
    private int dFlag = 0;
    private int cFlag = 0;
    private int ballFlag = 0;
    private int pinSound = 0;
    private Random rnd = new Random();
    private int adjustx;
    private int adjusty;
    private int tmp = 0;

    public static String[] getStringArray(Font font, String string, int n) {
        String[] stringArray;
        int n2 = string.length();
        int n3 = font.stringWidth(string) / n * 3;
        if (n3 < 5) {
            n3 = 5;
        }
        String[] stringArray2 = new String[n3];
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = string.indexOf(38);
        if (-1 == n8) {
            n8 = n2;
        }
        do {
            if (-1 == (n6 = string.indexOf(32, n6 + 1))) {
                n6 = n2;
            } else {
                int n9;
                n7 = string.indexOf(32, n6 + 1);
                if (-1 == n7) {
                    n7 = n2;
                }
                if (n8 != n2 && (n9 = string.indexOf(38, n6 + 1)) < n7) {
                    n7 = n9;
                }
            }
            if (n8 <= n6) {
                bl = true;
                n6 = n8;
                if (-1 == (n8 = string.indexOf(38, n8 + 1))) {
                    n8 = n2;
                }
            }
            if (!bl && n >= font.substringWidth(string, n5, n7 - n5)) continue;
            bl = false;
            if (n < font.substringWidth(string, n5, n6 - n5)) {
                while (n - 10 < font.substringWidth(string, n5, --n6 - n5)) {
                }
                stringArray2[n4] = string.substring(n5, n6) + "-";
                --n6;
            } else {
                stringArray2[n4] = string.substring(n5, n6);
            }
            if (++n4 >= n3) {
                stringArray = new String[n3];
                System.arraycopy(stringArray2, 0, stringArray, 0, n3);
                stringArray2 = new String[n3 *= 2];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray = null;
            }
            n5 = ++n6;
        } while (n6 < n2);
        stringArray = new String[n4];
        System.arraycopy(stringArray2, 0, stringArray, 0, n4);
        return stringArray;
    }

    public static int drawStringArray(Graphics graphics, int n, int n2, Font font, String[] stringArray, int n3, int n4, int n5) {
        int n6 = font.getHeight() + 1;
        int n7 = 0;
        while (n7 < stringArray.length) {
            if (n <= n4 && n4 < n2) {
                graphics.drawString(stringArray[n7], n3, n4, n5);
            }
            n4 += n6;
            ++n7;
        }
        return n4;
    }

    private void drawScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n * n3 / n5;
        if (n4 > n5) {
            n4 = n5;
        }
        graphics.setColor(n6);
        graphics.fillRect(178 - n2, 0, n2, n);
        graphics.setColor(n7);
        graphics.fillRect(179 - n2, 1, n2 - 2, n - 2);
        graphics.setColor(n8);
        graphics.fillRect(179 - n2, n9 + 1, n2 - 2, n * n4 / n5 - n9 - 2);
    }

    protected int drawText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        do {
            if ((n7 = ((n6 = string.indexOf("&", n5)) == -1 ? string.length() : n6) - n5) > 0 && n2 >= 0 && n2 < 208) {
                graphics.drawSubstring(string, n5, n7, n, n2, n3);
            }
            n5 = n6 + 1;
            n2 += n4;
        } while (n6 != -1);
        return n2;
    }

    private void drawFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(0, 0, 178, 208);
        graphics.setColor(n3);
        graphics.fillRect(0, n - n2, 178, n2);
        graphics.setColor(n4);
        graphics.fillRect(4, n - n2 + 4, 173, n2 - 5);
        graphics.setColor(n5);
        graphics.fillRect(2, n - n2 + 2, 173, n2 - 5);
        graphics.setColor(n6);
        graphics.fillRect(3, n - n2 + 3, 171, n2 - 7);
    }

    private void drawAlert(Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        this.drawFrame(graphics, n, n2, n3, n4, n5, n6);
        graphics.setColor(n7);
        graphics.setFont(this.FONT_MEDIUM);
        this.drawText(graphics, string, 10, n - n2 + 7, 20, this.FONT_MEDIUM.getHeight());
    }

    protected void drawItems(Graphics graphics, String[] stringArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11 = n3 * this.FONT_MEDIUM.getHeight() + 7;
        if (n < n2) {
            n = n2;
        }
        if (n11 > this.VIEW_HEIGHT) {
            n3 = (this.VIEW_HEIGHT - 7) / this.FONT_MEDIUM.getHeight();
            n11 = n3 * this.FONT_MEDIUM.getHeight() + 7;
            if (n - n2 >= n3) {
                n2 = n - n3 + 1;
            }
        }
        this.drawFrame(graphics, this.VIEW_HEIGHT, n11, n4, n5, n6, n7);
        graphics.setColor(n9);
        graphics.fillRect(3, this.VIEW_HEIGHT - n11 + 3 + this.FONT_MEDIUM.getHeight() * (n - n2), 171, this.FONT_MEDIUM.getHeight());
        graphics.setFont(this.FONT_MEDIUM);
        graphics.setColor(n8);
        int n12 = this.VIEW_HEIGHT - n11 + 4;
        int n13 = n2;
        while (n13 < n2 + n3) {
            graphics.drawString(stringArray[n13], 10, n12, 20);
            n12 += this.FONT_MEDIUM.getHeight();
            ++n13;
        }
        if (n10 != -1) {
            graphics.setColor(n4);
            graphics.drawString(stringArray[n], 10, this.VIEW_HEIGHT - n11 + 4 + this.FONT_MEDIUM.getHeight() * (n - n2), 20);
        }
    }

    protected void clearScreen(Graphics graphics, int n) {
        graphics.setClip(0, 0, 178, 208);
        graphics.setColor(n);
        graphics.fillRect(0, 0, 178, 208);
    }

    public BowlingCanvas(Bowling bowling) {
        this.SCORE_BOARD_HEIGHT = 25;
        this.SCREEN_WIDTH = 178;
        this.SCREEN_HEIGHT = 208;
        this.MOVE_BALL_MINIUM_X = 22;
        this.MOVE_BALL_MAXIUM_X = 156;
        this.MOVE_BALL_GAP_X = 12;
        this.CLEAR_BAR_X = 51;
        this.CLEAR_BAR_Y = 23;
        this.CLOSEUP_GUTTER_X_LEFT = 13;
        this.CLOSEUP_GUTTER_X_RIGHT = 164;
        this.CLOSEUP_GUTTER_X_GAP = 4;
        this.SCORE_BOX_Y = 135;
        this.midlet = bowling;
        this.arrInstructionsText = BowlingCanvas.getStringArray(this.FONT_MEDIUM, "4,6Key: Move Left/Right.& 5Key : Accept Spin/Speed", 166);
        this.arrDemoText = BowlingCanvas.getStringArray(this.FONT_MEDIUM, "This is a demo version. The full version is available from your carrier / operator.", 174);
        this.nInstructionsLength = this.arrInstructionsText.length + 1;
    }

    protected void startCanvas() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    protected void pauseCanvas() {
        if (this.nState == 5) {
            this.setCurrentState(11);
        }
    }

    protected void destroyCanvas() {
        this.midlet.notifyDestroyed();
    }

    protected void setCurrentState(int n) {
        if (n == 12) {
            this.nState = this.nPreviousState;
            this.nPreviousState = this.nSecondPreviousState;
        } else {
            this.nSecondPreviousState = this.nPreviousState;
            this.nPreviousState = this.nState;
            this.nState = n;
        }
        if (this.nState == 3) {
            this.stopSound();
            this.playSound(0);
            this.repaint();
            this.sleep(100);
            this.updateHighScore();
            this.saveData();
            this.initValues();
        } else if (this.nState == 5) {
            if (this.nPreviousState != 11) {
                // empty if block
            }
        } else if (this.nState == 1) {
            this.nCurrentIndex = 0;
            this.resetStopWatch();
        } else if (this.nState == 2) {
            this.resetStopWatch();
        } else if (this.nState == 8) {
            this.nHelpIndex = 0;
        } else if (this.nState == 11) {
            this.blnPause = true;
            if (this.nPauseIndex == 0) {
                this.nPauseIndex = 1;
            }
        }
        this.updateCommands(this.nState);
        this.repaint();
    }

    protected void doJob(int n) {
        switch (n) {
            case 0: {
                this.setCurrentState(5);
                break;
            }
            case 1: {
                this.setCurrentState(8);
                break;
            }
            case 2: {
                this.setCurrentState(6);
                break;
            }
            case 3: {
                this.setCurrentState(9);
                break;
            }
            case 4: {
                this.setCurrentState(7);
                break;
            }
            case 5: {
                if (this.nState == 4) {
                    this.destroyCanvas();
                    break;
                }
                this.setCurrentState(3);
            }
        }
    }

    protected void startGame() {
        this.initValues();
    }

    protected void keyPressed(int n) {
        if (this.nState == 5) {
            this.keyPressedPlaying(n);
        } else if (this.nState == 4) {
            this.keyPressedMenu(n);
        } else if (this.nState == 8) {
            this.keyPressedHelp(n);
        } else if (this.nState == 6) {
            this.keyPressedScore(n);
        } else if (this.nState == 9) {
            this.keyPressedSetup(n);
        } else if (this.nState == 7) {
            this.keyPressedAbout(n);
        } else if (this.nState == 13) {
            this.keyPressedGameOver(n);
        } else if (this.nState == 3) {
            this.keyPressedTitle(n);
        } else if (this.nState == 11) {
            this.keyPressedPause(n);
        } else if (this.nState == 1) {
            this.setCurrentState(2);
        } else if (this.nState == 2) {
            this.setCurrentState(1000);
        }
    }

    protected void keyRepeated(int n) {
        if (this.nState != 5) {
            this.keyPressed(n);
        }
    }

    protected void keyReleased(int n) {
        if (this.nKeyState == 1) {
            this.nKeyState = 2;
        } else {
            this.nKeyState = 0;
            this.nKeyCode = 0;
        }
    }

    protected void keyReset() {
        if (this.nKeyState == 1) {
            this.nKeyState = 3;
        } else if (this.nKeyState == 2) {
            this.nKeyState = 0;
            this.nKeyCode = 0;
        }
    }

    protected void setCommands(String string, String string2) {
        this.strLeftCommand = string;
        this.strRightCommand = string2;
    }

    protected void updateCommands(int n) {
        if (n == 11) {
            this.setCommands("Select", "Back");
        } else if (n == 4) {
            this.setCommands("Select", "Back");
        } else if (n == 13) {
            this.setCommands("Close", "Retry");
        } else if (n == 8) {
            this.setCommands(null, "Back");
        } else if (n == 6) {
            this.setCommands(null, "Back");
        } else if (n == 9) {
            this.setCommands("Change", "Back");
        } else if (n == 3) {
            this.setCommands("Options", "Play");
        } else if (n == 7) {
            this.setCommands(null, "Back");
        } else if (n == 5) {
            this.setCommands(null, "Options");
        }
    }

    private void drawCurrentCommands(Graphics graphics, int n) {
        graphics.setClip(0, 0, 178, 208);
        graphics.setColor(n);
        graphics.fillRect(0, this.VIEW_HEIGHT, 178, 208 - this.VIEW_HEIGHT);
        graphics.setColor(0);
        graphics.setFont(this.FONT_MEDIUM);
        if (this.strLeftCommand != null) {
            graphics.drawString(this.strLeftCommand, 2, 208, 36);
        }
        if (this.strRightCommand != null) {
            graphics.drawString(this.strRightCommand, 176, 208, 40);
        }
    }

    public void run() {
        do {
            this.sleep(100);
        } while (!this.isShown());
        this.nCurrentIndex = 0;
        this.waitForID(this.nCurrentIndex);
        this.waitForID(this.nCurrentIndex);
        this.setCurrentState(2);
        while (true) {
            if (this.nState == 5) {
                this.runPlaying();
                continue;
            }
            if (this.nState == 1) {
                this.waitForID(this.nCurrentIndex);
                this.repaint();
                if (this.getStopWatchTime() < 3000L) continue;
                this.setCurrentState(2);
                continue;
            }
            if (this.nState == 2) {
                this.waitForID(this.nCurrentIndex);
                this.repaint();
                if (this.getStopWatchTime() < 3000L) continue;
                this.setCurrentState(1000);
                continue;
            }
            if (this.nState == 1000) {
                this.repaint();
                if (!this.waitForID(this.nCurrentIndex)) continue;
                this.loadData();
                this.setCurrentState(3);
                continue;
            }
            if (this.nState == 3) {
                this.sleep(100);
                continue;
            }
            this.sleep(100);
        }
    }

    protected void paint(Graphics graphics) {
        if (this.nState == 5) {
            this.paintPlaying(graphics);
        } else if (this.nState == 11) {
            this.clearScreen(graphics, 9231100);
            this.paintPause(graphics);
            this.drawCurrentCommands(graphics, 9231100);
        } else if (this.nState == 4) {
            this.paintMenu(graphics);
            this.drawCurrentCommands(graphics, 9231100);
        } else if (this.nState == 13) {
            this.clearScreen(graphics, 9231100);
            this.paintGameOver(graphics);
            this.drawCurrentCommands(graphics, 9231100);
        } else if (this.nState == 8) {
            this.paintHelp(graphics);
            this.drawCurrentCommands(graphics, 9231100);
        } else if (this.nState == 6) {
            this.paintScore(graphics);
            this.drawCurrentCommands(graphics, 9231100);
        } else if (this.nState == 9) {
            this.paintSettings(graphics);
            this.drawCurrentCommands(graphics, 9231100);
        } else if (this.nState == 3) {
            this.paintTitle(graphics);
            this.drawCurrentCommands(graphics, 9231100);
        } else if (this.nState == 7) {
            this.paintAbout(graphics);
            this.drawCurrentCommands(graphics, 0xFFFFFF);
        } else if (this.nState == 1) {
            this.clearScreen(graphics, 0);
            this.drawImageCenter(graphics, this.IMAGES[0]);
        } else if (this.nState == 2) {
            this.clearScreen(graphics, 0xFFFFFF);
            this.drawImageCenter(graphics, this.IMAGES[1]);
        } else if (this.nState == 1000) {
            this.paintLoading(graphics);
        }
    }

    protected void resetStopWatch() {
        this.lStopWatchStartTime = System.currentTimeMillis();
    }

    protected long getStopWatchTime() {
        return System.currentTimeMillis() - this.lStopWatchStartTime;
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getKeyDirection(int n) {
        if (n == 53) {
            return 8;
        }
        if (n == 50) {
            return 1;
        }
        if (n == 56) {
            return 6;
        }
        if (n == 54) {
            return 5;
        }
        if (n == 52) {
            return 2;
        }
        if (n == -6) {
            return -6;
        }
        if (n == -7) {
            return -7;
        }
        if (n == -5) {
            return 8;
        }
        return this.getGameAction(n);
    }

    private void drawImageClip(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6) {
        graphics.setClip(n, n2, n5, n6);
        graphics.drawImage(image, n - n3, n2 - n4, 20);
    }

    private void drawImageCenter(Graphics graphics, Image image) {
        this.drawImageCenter(graphics, image, 0, 0);
    }

    private void drawImageCenter(Graphics graphics, Image image, int n, int n2) {
        if (image != null) {
            graphics.drawImage(image, 89 + n, (208 - image.getHeight()) / 2 + n2, 17);
        }
    }

    private void drawOutlineString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n4);
        graphics.drawString(string, n - 1, n2, n3);
        graphics.drawString(string, n + 1, n2, n3);
        graphics.drawString(string, n, n2 - 1, n3);
        graphics.drawString(string, n, n2 + 1, n3);
        graphics.setColor(n5);
        graphics.drawString(string, n, n2, n3);
    }

    private void drawBoldString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n4);
        graphics.drawString(string, n, n2 - 1, n3);
        graphics.drawString(string, n, n2 + 1, n3);
        graphics.setColor(n5);
        graphics.drawString(string, n, n2, n3);
    }

    protected static int drawStringCenter(Graphics graphics, String string, int n) {
        graphics.drawString(string, 7, n, 20);
        return n + 16;
    }

    protected void drawHeader(Graphics graphics, String string) {
        int n = 0xFFFFFF;
        graphics.setClip(0, 0, 178, 208);
        int n2 = 10;
        while (n2 >= 0) {
            graphics.setColor(n);
            n -= 0x191900;
            graphics.fillRect(n2 * 17, this.HEADER_HEIGHT - 7, (n2 + 1) * 17, 7);
            --n2;
        }
        graphics.setColor(0);
        graphics.setFont(this.FONT_LARGE);
        graphics.drawString(string, 89, 0, 17);
    }

    private boolean waitForID(int n) {
        block4: {
            try {
                if (n < 19) {
                    this.IMAGES[n] = Image.createImage((String)("/image/" + n + ".png"));
                    break block4;
                }
                if (n < 23) {
                    this.SOUNDS[n - 19] = new Sound(this.readFile("/sound/" + (n - 19) + ".ott", SOUND_SIZES[n - 19]), 1);
                    break block4;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ++this.nCurrentIndex;
        return false;
    }

    private byte[] readFile(String string, int n) {
        byte[] byArray = new byte[n];
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            inputStream.read(byArray);
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    private void playSound(int n) {
        if (this.byGameSetting[0] == 0) {
            try {
                this.currentSound = this.SOUNDS[n];
                this.currentSound.play(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopSound() {
        if (this.currentSound != null) {
            try {
                this.currentSound.stop();
                this.currentSound = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void vibrate(int n, int n2) {
        if (this.byGameSetting[1] == 0) {
            try {
                DeviceControl.startVibra((int)n, (long)n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void flashLights(long l) {
        if (this.byGameSetting[2] == 0) {
            try {
                this.flashLights(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setBacklight() {
        try {
            DeviceControl.setLights((int)0, (int)(this.byGameSetting[2] == 0 ? 100 : 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintLoading(Graphics graphics) {
        int n = this.nCurrentIndex * 148 / 22;
        if (n > 148) {
            n = 148;
        }
        this.drawAlert(graphics, 208, 45, "Loading...", 0xFFFFFF, 0xC0C0C0, 0, 0xFFFFFF, 0x404040);
        graphics.setColor(0x404040);
        graphics.fillRect(14, 190, 150, 11);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(15, 191, 148, 9);
        graphics.setColor(0xC0C0C0);
        graphics.fillRect(15, 191, n, 9);
    }

    protected void loadData() {
        try {
            this.rsData = RecordStore.openRecordStore((String)"com2us", (boolean)true);
            if (this.rsData.getNumRecords() < 2) {
                this.putInt(this.byGameSetting, 0);
                this.rsData.addRecord(this.byGameSetting, 0, this.byGameSetting.length);
                this.putInt(this.byGameSetting, 1);
                this.rsData.addRecord(this.byGameSetting, 0, this.byGameSetting.length);
                this.putInt(this.byGameSetting, 0);
                int n = 0;
                while (n < 5) {
                    this.rsData.addRecord(this.byGameSetting, 0, this.byGameSetting.length);
                    ++n;
                }
            } else {
                this.byGameSetting = this.rsData.getRecord(1);
                this.nStageStored = this.getInt(this.rsData.getRecord(2));
                int n = 0;
                while (n < 5) {
                    this.nHighScore[n] = this.getInt(this.rsData.getRecord(3 + n));
                    ++n;
                }
            }
            this.rsData.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    protected void saveData() {
        try {
            this.rsData = RecordStore.openRecordStore((String)"com2us", (boolean)true);
            byte[] byArray = new byte[4];
            this.rsData.setRecord(1, this.byGameSetting, 0, this.byGameSetting.length);
            this.putInt(byArray, this.nStageStored);
            this.rsData.setRecord(2, byArray, 0, byArray.length);
            int n = 0;
            while (n < 5) {
                this.putInt(byArray, this.nHighScore[n]);
                this.rsData.setRecord(3 + n, byArray, 0, byArray.length);
                ++n;
            }
            this.rsData.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    protected void updateHighScore() {
        int n = 0;
        while (n < 5) {
            if (this.nHighScore[n] < this.nScore) {
                if (4 != n) {
                    int[] nArray = new int[4 - n];
                    System.arraycopy(this.nHighScore, n, nArray, 0, nArray.length);
                    System.arraycopy(nArray, 0, this.nHighScore, n + 1, nArray.length);
                }
                this.nHighScore[n] = this.nScore;
                this.nScore = 0;
                return;
            }
            ++n;
        }
    }

    private int getInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private void putInt(byte[] byArray, int n) {
        byArray[0] = (byte)(n >> 24 & 0xFF);
        byArray[1] = (byte)(n >> 16 & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n >> 0 & 0xFF);
    }

    protected void keyPressedTitle(int n) {
        if (n == -6) {
            this.setCurrentState(4);
        } else if (this.getKeyDirection(n) == 8 || n == -7) {
            this.setCurrentState(5);
        }
    }

    private void paintTitle(Graphics graphics) {
        this.drawBackGround(graphics);
        this.drawImageCenter(graphics, this.IMAGES[3], 0, -38);
        this.drawImageCenter(graphics, this.IMAGES[4], 0, 70);
    }

    protected void keyPressedMenu(int n) {
        if (this.getKeyDirection(n) == 1) {
            this.nMenuIndex = this.nMenuIndex > 0 ? --this.nMenuIndex : 5;
            this.repaint();
        } else if (this.getKeyDirection(n) == 6) {
            this.nMenuIndex = this.nMenuIndex < 5 ? ++this.nMenuIndex : 0;
            this.repaint();
        } else if (this.getKeyDirection(n) == 8 || n == -6) {
            this.doJob(this.nMenuIndex);
        } else if (n == -7) {
            this.setCurrentState(3);
        }
    }

    private void paintMenu(Graphics graphics) {
        this.paintTitle(graphics);
        this.drawItems(graphics, MENU_ITEMS, this.nMenuIndex, 0, 6, 9231100, 0x404040, 0, 0xFFFFFF, 0, 0x8080FF, -1);
    }

    protected void keyPressedPause(int n) {
        if (this.getKeyDirection(n) == 1) {
            this.nPauseIndex = this.nPauseIndex > 1 ? --this.nPauseIndex : 5;
            this.repaint();
        } else if (this.getKeyDirection(n) == 6) {
            this.nPauseIndex = this.nPauseIndex < 5 ? ++this.nPauseIndex : 1;
            this.repaint();
        } else if (this.getKeyDirection(n) == 8 || n == -6) {
            this.doJob(this.nPauseIndex);
        } else if (n == -7) {
            this.setCurrentState(12);
        }
    }

    private void paintPause(Graphics graphics) {
        this.drawItems(graphics, MENU_ITEMS, this.nPauseIndex, 1, 5, 9231100, 0x404040, 0, 0xFFFFFF, 0, 0x8080FF, -1);
    }

    protected void keyPressedHelp(int n) {
        int n2 = (this.VIEW_HEIGHT - 20) / this.FONT_MEDIUM.getHeight();
        if (this.getKeyDirection(n) == 1 && this.nHelpIndex > 0) {
            --this.nHelpIndex;
            this.repaint();
        } else if (this.getKeyDirection(n) == 6 && this.nHelpIndex < this.nInstructionsLength - n2) {
            ++this.nHelpIndex;
            this.repaint();
        } else if (n == -7 || this.getKeyDirection(n) == 8) {
            this.setCurrentState(12);
        }
    }

    private void paintHelp(Graphics graphics) {
        int n = this.nHelpIndex * (this.FONT_MEDIUM.getHeight() + 1);
        int n2 = (this.VIEW_HEIGHT - 20) / this.FONT_MEDIUM.getHeight();
        this.clearScreen(graphics, 9231100);
        graphics.setFont(this.FONT_MEDIUM);
        this.drawScrollBar(graphics, this.VIEW_HEIGHT, 8, this.nHelpIndex, this.nHelpIndex + n2, this.nInstructionsLength, 0, 0xC0C0C0, 255);
        graphics.setColor(0xFF0000);
        graphics.drawString("Instructions", 89, 4 - n, 17);
        graphics.setColor(0);
        graphics.setClip(0, 0, 168, this.VIEW_HEIGHT);
        BowlingCanvas.drawStringArray(graphics, 0, this.VIEW_HEIGHT, this.FONT_MEDIUM, this.arrInstructionsText, 2, 20 - n, 20);
    }

    protected void keyPressedScore(int n) {
        if (n == -7 || this.getKeyDirection(n) == 8) {
            this.setCurrentState(12);
        }
    }

    protected void paintScore(Graphics graphics) {
        int n = this.FONT_MEDIUM.getHeight() + this.FONT_SMALL.getHeight() + 1;
        this.clearScreen(graphics, 9231100);
        graphics.setColor(0);
        graphics.drawLine(20, this.HEADER_HEIGHT, 20, this.VIEW_HEIGHT - 2);
        graphics.drawLine(20, this.VIEW_HEIGHT - 2, this.getWidth(), this.VIEW_HEIGHT - 2);
        int n2 = 0;
        while (n2 < 5) {
            if (this.HEADER_HEIGHT + (n2 + 1) * n < this.VIEW_HEIGHT) {
                graphics.setFont(this.FONT_MEDIUM);
                graphics.drawString(String.valueOf(n2 + 1), 16, this.HEADER_HEIGHT + n2 * n, 24);
                graphics.setFont(this.FONT_SMALL);
                graphics.drawString(this.nHighScore[n2] + " ", 30, this.HEADER_HEIGHT + n2 * n + this.FONT_MEDIUM.getHeight(), 20);
            }
            ++n2;
        }
        this.drawHeader(graphics, "Score");
    }

    protected void paintGameOver(Graphics graphics) {
        this.drawAlert(graphics, this.VIEW_HEIGHT, 50, "Score: " + this.nScore, 9231100, 0xC0C0C0, 0, 0xFFFF00, 0);
    }

    protected void keyPressedGameOver(int n) {
        if (n == -6 || this.getKeyDirection(n) == 8) {
            this.setCurrentState(3);
        } else if (n == -7) {
            this.updateHighScore();
            this.saveData();
            this.setCurrentState(5);
        }
    }

    protected void changeSetting() {
        this.byGameSetting[this.nSettingIndex] = (byte)((this.byGameSetting[this.nSettingIndex] + 1) % 2);
        this.repaint();
    }

    protected void keyPressedSetup(int n) {
        if (n == -6 || this.getKeyDirection(n) == 8) {
            this.changeSetting();
        }
        if (n == -7) {
            this.setCurrentState(12);
        } else {
            switch (this.getKeyDirection(n)) {
                case 1: {
                    if (this.nSettingIndex <= 0) break;
                    --this.nSettingIndex;
                    this.repaint();
                    break;
                }
                case 6: {
                    if (this.nSettingIndex >= 0) break;
                    ++this.nSettingIndex;
                    this.repaint();
                }
            }
        }
    }

    protected void paintSettings(Graphics graphics) {
        int n = this.FONT_LARGE.getHeight() + this.FONT_MEDIUM.getHeight() + 7;
        this.clearScreen(graphics, 9231100);
        graphics.setColor(0);
        graphics.drawLine(5, this.HEADER_HEIGHT, 5, this.HEADER_HEIGHT + n * 1);
        graphics.setColor(0xC0C0C0);
        graphics.fillRect(2, this.HEADER_HEIGHT + 2 + this.nSettingIndex * n, 175, n - 2);
        graphics.setColor(0x8080FF);
        graphics.fillRect(1, this.HEADER_HEIGHT + 1 + this.nSettingIndex * n, 175, n - 2);
        int n2 = 0;
        while (n2 < 1) {
            graphics.setColor(0);
            graphics.drawLine(5, this.HEADER_HEIGHT + n * (n2 + 1), 178, this.HEADER_HEIGHT + n * (n2 + 1));
            graphics.setFont(this.FONT_LARGE);
            graphics.drawString(SETTING_ITEMS[n2], 20, this.HEADER_HEIGHT + 2 + n * n2, 20);
            graphics.setColor(0x404040);
            graphics.fillRect(55, this.HEADER_HEIGHT + 3 + this.FONT_LARGE.getHeight() + n * n2, 118, this.FONT_MEDIUM.getHeight());
            graphics.setFont(this.FONT_MEDIUM);
            graphics.setColor(0xC0C0C0);
            graphics.drawString(SWITCH_ITEMS[this.byGameSetting[n2] % 2], 114, this.HEADER_HEIGHT + 3 + this.FONT_LARGE.getHeight() + n * n2, 17);
            ++n2;
        }
        this.drawHeader(graphics, "Settings");
    }

    protected void keyPressedAbout(int n) {
        if (n == -7 || this.getKeyDirection(n) == 8) {
            this.setCurrentState(12);
        }
    }

    protected void paintAbout(Graphics graphics) {
        int n = this.FONT_MEDIUM.getHeight() + this.FONT_SMALL.getHeight() + 1;
        this.clearScreen(graphics, 0xFFFFFF);
        this.drawImageCenter(graphics, this.IMAGES[18], 0, (this.VIEW_HEIGHT - 208) / 2);
        this.drawHeader(graphics, "About");
    }

    protected void setRunState(int n) {
        if (this.nPlayStatus == 2) {
            this.nControlStatus = 0;
            this.nHook = 0;
            this.nHookTemp = Math.abs(this.rnd.nextInt()) % 8 + 1;
            this.nPowerMove = 0;
            this.nPower = 0;
            this.nSpeed = 0;
        }
        this.nPlayStatus = n;
    }

    protected void keyPressedPlaying(int n) {
        if (n == -7) {
            this.setCurrentState(11);
        } else if (this.nPlayStatus == 4 || this.nPlayStatus == 17) {
            this.nKeyCode = this.getKeyDirection(n);
            this.nKeyState = 1;
        }
    }

    protected void runPlaying() {
        if (this.nPlayStatus == 4) {
            if (this.nControlStatus == 0) {
                this.controlCharacter();
            } else if (this.nControlStatus == 1) {
                this.controlHook();
            } else if (this.nControlStatus == 2) {
                this.controlPower();
            }
        } else if (this.nPlayStatus == 17 && this.nKeyState != 0) {
            switch (this.nKeyCode) {
                case 8: {
                    int n = 0;
                    while (n <= 10) {
                        this.arrPin[n] = 0;
                        this.select2Flag[n] = 0;
                        this.tempFlag[n] = 0;
                        this.temp2Flag[n] = 0;
                        this.mx[n] = 0;
                        this.my[n] = 0;
                        this.mmy[n] = 0;
                        this.bm[n] = 4;
                        this.prebm[n] = 4;
                        ++n;
                    }
                    if (this.gFlag != 4) {
                        if (this.nPlayFrame < 9) {
                            ++this.nPlayFrame;
                        }
                        this.setRunState(1);
                        break;
                    }
                    this.playSound(1);
                    this.saveData();
                    this.initValues();
                    this.setCurrentState(13);
                }
            }
        }
        this.repaint();
        this.keyReset();
        this.sleep(100);
    }

    protected void controlCharacter() {
        if (this.nKeyState != 0) {
            switch (this.nKeyCode) {
                case 8: {
                    this.nControlStatus = 1;
                    this.nKeyState = 2;
                    break;
                }
                case 2: {
                    this.nBallX -= 6;
                    if (this.nBallX >= 22) break;
                    this.nBallX = 22;
                    break;
                }
                case 5: {
                    this.nBallX += 6;
                    if (this.nBallX <= 156) break;
                    this.nBallX = 156;
                }
            }
        }
    }

    protected void controlHook() {
        if (this.nKeyState != 0) {
            switch (this.nKeyCode) {
                case 8: {
                    this.nControlStatus = 2;
                    this.nKeyState = 2;
                }
            }
        }
    }

    protected void controlPower() {
        if (this.nKeyState != 0) {
            switch (this.nKeyCode) {
                case 8: {
                    this.nControlStatus = 0;
                    this.setRunState(5);
                }
            }
        }
    }

    private void drawBall(Graphics graphics, int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.setClipImage(graphics, n - 17, n2, this.IMAGES[10], 14, 81, 35, 35);
                break;
            }
            case 2: {
                this.setClipImage(graphics, n - 15, n2, this.IMAGES[10], 18, 50, 31, 31);
                break;
            }
            case 3: {
                this.setClipImage(graphics, n - 13, n2, this.IMAGES[10], 22, 23, 27, 27);
                break;
            }
            case 4: {
                this.setClipImage(graphics, n - 11, n2, this.IMAGES[10], 26, 0, 23, 23);
                break;
            }
            case 5: {
                this.setClipImage(graphics, n - 10, n2, this.IMAGES[10], 0, 17, 20, 20);
                break;
            }
            case 6: {
                this.setClipImage(graphics, n - 9, n2, this.IMAGES[10], 0, 37, 18, 18);
                break;
            }
            case 7: {
                this.setClipImage(graphics, n - 8, n2, this.IMAGES[10], 0, 55, 16, 16);
                break;
            }
            case 8: {
                this.setClipImage(graphics, n - 7, n2, this.IMAGES[10], 0, 71, 14, 14);
                break;
            }
            case 9: {
                this.setClipImage(graphics, n - 6, n2, this.IMAGES[10], 0, 85, 12, 12);
                break;
            }
            case 10: {
                this.setClipImage(graphics, n - 5, n2, this.IMAGES[10], 0, 97, 10, 10);
                break;
            }
            case 11: {
                this.setClipImage(graphics, n - 4, n2, this.IMAGES[10], 0, 107, 9, 9);
                break;
            }
        }
    }

    private void drawDarkBall(Graphics graphics, int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.setClipImage(graphics, n - 10, n2, this.IMAGES[10], 49, 0, 20, 20);
                break;
            }
            case 2: {
                this.setClipImage(graphics, n - 9, n2, this.IMAGES[10], 49, 20, 18, 18);
                break;
            }
            case 3: {
                this.setClipImage(graphics, n - 8, n2, this.IMAGES[10], 49, 38, 16, 16);
                break;
            }
        }
    }

    private void drawSmallPins(Graphics graphics) {
        int n = 10;
        while (n >= 1) {
            if (this.arrPin[n] == 0) {
                graphics.drawImage(this.IMAGES[9], this.SMALL_PIN_X[n], this.SMALL_PIN_Y[n], 20);
            }
            --n;
        }
    }

    private void drawLargePin(Graphics graphics, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                this.setClipImage(graphics, n, n2, this.IMAGES[8], 0, 28, 39, 11);
                break;
            }
            case 1: {
                this.setClipImage(graphics, n, n2, this.IMAGES[8], 40, 20, 38, 19);
                break;
            }
            case 2: {
                this.setClipImage(graphics, n, n2, this.IMAGES[8], 79, 8, 30, 31);
                break;
            }
            case 3: {
                this.setClipImage(graphics, n, n2, this.IMAGES[8], 110, 1, 19, 38);
                break;
            }
            case 4: {
                this.setClipImage(graphics, n, n2, this.IMAGES[8], 130, 0, 11, 39);
                break;
            }
            case 5: {
                this.setClipImage(graphics, n, n2, this.IMAGES[8], 0, 40, 19, 38);
                break;
            }
            case 6: {
                this.setClipImage(graphics, n, n2, this.IMAGES[8], 20, 47, 30, 31);
                break;
            }
            case 7: {
                this.setClipImage(graphics, n, n2, this.IMAGES[8], 51, 59, 38, 19);
                break;
            }
            case 8: {
                this.setClipImage(graphics, n, n2, this.IMAGES[8], 90, 67, 39, 11);
                break;
            }
            default: {
                System.out.println("========== out of index " + n3);
            }
        }
    }

    private void drawCharacter(Graphics graphics, int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                this.setClipImage(graphics, n, 115, this.IMAGES[7], 0, 223, 71, 93);
                break;
            }
            case 1: {
                this.setClipImage(graphics, n, 116, this.IMAGES[7], 264, 116, 64, 92);
                break;
            }
            case 2: {
                this.setClipImage(graphics, n, 116, this.IMAGES[7], 0, 22, 64, 92);
                break;
            }
            case 3: {
                this.setClipImage(graphics, n, 116, this.IMAGES[7], 65, 22, 64, 92);
                break;
            }
            case 4: {
                this.setClipImage(graphics, n, 109, this.IMAGES[7], 130, 15, 74, 99);
                break;
            }
            case 5: {
                this.setClipImage(graphics, n, 94, this.IMAGES[7], 205, 0, 71, 114);
                break;
            }
            case 6: {
                this.setClipImage(graphics, n, 115, this.IMAGES[7], 74, 223, 67, 93);
                break;
            }
            case 7: {
                this.setClipImage(graphics, n, 115, this.IMAGES[7], 142, 223, 68, 93);
                break;
            }
            case 8: {
                this.setClipImage(graphics, n, 101, this.IMAGES[7], 211, 209, 78, 107);
                break;
            }
            case 9: {
                this.setClipImage(graphics, n, 115, this.IMAGES[7], 128, 115, 67, 93);
                break;
            }
            case 10: {
                this.setClipImage(graphics, n, 115, this.IMAGES[7], 196, 115, 67, 93);
                break;
            }
            case 11: {
                this.setClipImage(graphics, n, 115, this.IMAGES[7], 0, 115, 67, 93);
                break;
            }
            case 12: {
                this.setClipImage(graphics, n, 124, this.IMAGES[7], 68, 124, 58, 84);
            }
        }
    }

    private void drawCharacterThrowAction(Graphics graphics) {
        this.eraseCharacter(graphics);
        switch (this.ballFlag) {
            case 1: {
                this.drawBall(graphics, this.nBallX + 2, 158, 1);
                this.drawCharacter(graphics, this.nBallX - 9 - 15, 116, 2);
                break;
            }
            case 2: {
                this.drawCharacter(graphics, this.nBallX - 9 - 29, 116, 3);
                break;
            }
            case 3: {
                this.drawCharacter(graphics, this.nBallX - 9 - 43, 109, 4);
                break;
            }
            default: {
                this.drawCharacter(graphics, this.nBallX - 9 - 44, 94, 5);
            }
        }
        ++this.ballFlag;
    }

    private void drawRemainPinGaugeCircle(Graphics graphics, int n, int n2) {
        this.setClipImage(graphics, n, n2, this.IMAGES[16], 36, 34, 5, 5);
    }

    private void drawHookGaugeCircle(Graphics graphics, int n, int n2, int n3) {
        this.setClipImage(graphics, n, n2, this.IMAGES[12], 1 + n3 * 8, 1, 7, 7);
    }

    private void eraseCharacter(Graphics graphics) {
        this.setClipImage(graphics, 0, 113, this.IMAGES[2], 0, 113, 178, 100);
    }

    private void setClipImage(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6) {
        graphics.setClip(n, n2, n5, n6);
        graphics.drawImage(image, n - n3, n2 - n4, 0);
        graphics.setClip(0, 0, 178, 208);
    }

    private void paintPlaying(Graphics graphics) {
        if (this.blnPause) {
            this.drawBackGround(graphics);
            this.drawSmallPins(graphics);
            this.drawRemainPinsViewer(graphics);
            if (this.nControlStatus >= 0) {
                this.drawBall(graphics, this.nBallX, 158, 1);
                this.drawCharacter(graphics, this.nBallX - 38, 115, 1);
                this.ballFlag = 1;
            }
            if (this.nControlStatus >= 1) {
                this.drawHookGauge(graphics);
            }
            if (this.nControlStatus >= 2) {
                this.drawPowerGauge(graphics);
            }
            if (this.nPlayStatus == 17) {
                this.setScore();
                this.DisplayScore(graphics);
            }
            this.blnPause = false;
        }
        switch (this.nPlayStatus) {
            case 0: {
                this.clearScreen(graphics, 0xFFFFFF);
                this.nPlayStatus = 1;
                break;
            }
            case 1: {
                this.drawBackGround(graphics);
                this.drawRemainPinsViewer(graphics);
                this.nPlayStatus = 2;
                this.nClearBarMoveY = 0;
                this.blnClearBarUp = false;
                break;
            }
            case 2: {
                this.drawClearBar(graphics);
                if (!this.blnClearBarUp) {
                    this.nClearBarMoveY += 2;
                }
                if (this.nClearBarMoveY > 10) {
                    this.blnClearBarUp = true;
                }
                if (!this.blnClearBarUp) break;
                this.nClearBarMoveY -= 2;
                if (this.nClearBarMoveY >= 2) break;
                this.eraseClearBar(graphics);
                this.drawSmallPin(graphics);
                this.nPlayStatus = 4;
                this.blnClearBarUp = false;
                this.nClearBarMoveY = 0;
                if (this.nBallThrowCnt != 2) break;
                this.nBallThrowCnt = 0;
                break;
            }
            case 4: {
                if (this.nControlStatus == 0) {
                    this.eraseCharacter(graphics);
                    this.drawBall(graphics, this.nBallX, 158, 1);
                    this.drawCharacter(graphics, this.nBallX - 38, 115, 1);
                    this.ballFlag = 1;
                    break;
                }
                if (this.nControlStatus == 1) {
                    this.setHook(graphics);
                    this.drawHookGauge(graphics);
                    break;
                }
                if (this.nControlStatus != 2) break;
                this.setPower(graphics);
                this.drawPowerGauge(graphics);
                break;
            }
            case 5: {
                this.setSpeedAngle();
                this.nPlayStatus = 6;
                break;
            }
            case 6: {
                this.drawCharacterThrowAction(graphics);
                if (this.ballFlag != 5) break;
                this.ballFlag = 1;
                this.nPlayStatus = 7;
                break;
            }
            case 7: {
                this.drawMovingBall(graphics);
                this.drawSmallPin(graphics);
                this.drawCharacter(graphics, this.nBallX - 9 - 44, 94, 5);
                if (this.moveBall[this.nFrame][1] <= 50) {
                    if (this.nBallThrowCnt == 0) {
                        this.idx = -1;
                        this.nBallThrowCnt = 1;
                        this.nPlayStatus = this.nPlayFrame < 9 ? 8 : 10;
                    } else if (this.nBallThrowCnt == 1) {
                        this.idx = -1;
                        this.nBallThrowCnt = 2;
                        this.nPlayStatus = this.nPlayFrame < 9 ? 9 : 10;
                    }
                    this.pinSound = 0;
                }
                this.bFlag = 0;
                --this.nFrame;
                break;
            }
            case 8: {
                this.setRemovedPin(this.nCloseupBallX, this.nCloseupFrame);
                this.DisplayCloseup(graphics);
                if (this.pinSound == 1) {
                    this.playSound(3);
                }
                ++this.nCloseupFrame;
                if (this.nCloseupFrame != 6) break;
                this.nCloseupFrame = 0;
                this.firstScore();
                int n = 0;
                while (n <= 10) {
                    this.mx[n] = 0;
                    this.my[n] = 0;
                    this.mmy[n] = 0;
                    this.bm[n] = 4;
                    this.prebm[n] = 4;
                    ++n;
                }
                this.pnS = true;
                if (this.strike[this.nPlayFrame] == 1) {
                    this.vibrate(50, 100);
                    this.nBallThrowCnt = 2;
                    this.blnEndFrame = true;
                    this.nPlayStatus = 11;
                    break;
                }
                this.blnEndFrame = false;
                this.nPlayStatus = 11;
                break;
            }
            case 9: {
                this.DisplayCloseup(graphics);
                if (this.pinSound == 1) {
                    this.playSound(3);
                }
                ++this.nCloseupFrame;
                if (this.nCloseupFrame != 6) break;
                this.nCloseupFrame = 0;
                this.secondScore();
                int n = 0;
                while (n <= 10) {
                    this.mx[n] = 0;
                    this.my[n] = 0;
                    this.mmy[n] = 0;
                    this.bm[n] = 4;
                    this.prebm[n] = 4;
                    ++n;
                }
                this.pnS = true;
                if (this.spare[this.nPlayFrame] == 1) {
                    this.vibrate(50, 100);
                }
                this.nBallThrowCnt = 2;
                this.blnEndFrame = true;
                this.nPlayStatus = 11;
                break;
            }
            case 10: {
                this.DisplayCloseup(graphics);
                if (this.pinSound == 1) {
                    this.playSound(3);
                }
                ++this.nCloseupFrame;
                if (this.nCloseupFrame != 6) break;
                this.nCloseupFrame = 0;
                int n = 0;
                int n2 = 10;
                while (n2 >= 1) {
                    if (this.arrPin[n2] > 0) {
                        ++n;
                    }
                    --n2;
                }
                if (this.gFlag == 1) {
                    this.score1[this.nPlayFrame] = n;
                } else if (this.gFlag == 2) {
                    this.score2[this.nPlayFrame] = n;
                } else if (this.gFlag == 12) {
                    this.score2[this.nPlayFrame] = n - this.score1[this.nPlayFrame];
                } else if (this.gFlag == 3) {
                    this.score3[this.nPlayFrame] = n;
                } else if (this.gFlag == 13) {
                    this.score3[this.nPlayFrame] = n - this.score2[this.nPlayFrame];
                }
                int n3 = 0;
                while (n3 <= 10) {
                    this.mx[n3] = 0;
                    this.my[n3] = 0;
                    this.mmy[n3] = 0;
                    this.bm[n3] = 4;
                    this.prebm[n3] = 4;
                    ++n3;
                }
                this.pnS = true;
                switch (this.gFlag) {
                    case 1: {
                        if (this.score1[this.nPlayFrame] == 10) {
                            this.strike[this.nPlayFrame] = 1;
                            this.vibrate(50, 100);
                            this.gFlag = 2;
                            this.nBallThrowCnt = 2;
                            this.blnEndFrame = true;
                            this.nPlayStatus = 11;
                            break;
                        }
                        this.gFlag = 12;
                        this.blnEndFrame = false;
                        this.nPlayStatus = 11;
                        break;
                    }
                    case 2: {
                        if (this.score2[this.nPlayFrame] == 10) {
                            this.strike[this.nPlayFrame] = 1;
                            this.vibrate(50, 100);
                            this.gFlag = 3;
                            this.nBallThrowCnt = 2;
                            this.blnEndFrame = true;
                            this.nPlayStatus = 11;
                            break;
                        }
                        this.strike[this.nPlayFrame] = 0;
                        this.gFlag = 13;
                        this.blnEndFrame = false;
                        this.nPlayStatus = 11;
                        break;
                    }
                    case 3: {
                        if (this.score3[this.nPlayFrame] == 10) {
                            this.strike[this.nPlayFrame] = 1;
                            this.vibrate(50, 100);
                        } else {
                            this.strike[this.nPlayFrame] = 0;
                            this.spare[this.nPlayFrame] = 0;
                        }
                        this.gFlag = 4;
                        this.nBallThrowCnt = 2;
                        this.blnEndFrame = true;
                        this.nPlayStatus = 11;
                        break;
                    }
                    case 13: {
                        if (this.score2[this.nPlayFrame] + this.score3[this.nPlayFrame] == 10) {
                            this.spare[this.nPlayFrame] = 1;
                            this.vibrate(50, 100);
                        } else {
                            this.spare[this.nPlayFrame] = 0;
                        }
                        this.gFlag = 4;
                        this.nBallThrowCnt = 2;
                        this.blnEndFrame = true;
                        this.nPlayStatus = 11;
                        break;
                    }
                    case 12: {
                        if (this.score1[this.nPlayFrame] + this.score2[this.nPlayFrame] == 10) {
                            this.spare[this.nPlayFrame] = 1;
                            this.vibrate(50, 100);
                            this.gFlag = 3;
                            this.nBallThrowCnt = 2;
                            this.blnEndFrame = true;
                            this.nPlayStatus = 11;
                            break;
                        }
                        this.spare[this.nPlayFrame] = 0;
                        this.gFlag = 4;
                        this.nBallThrowCnt = 2;
                        this.blnEndFrame = true;
                        this.nPlayStatus = 11;
                    }
                }
                break;
            }
            case 11: {
                if (this.pnS) {
                    this.drawBackGround(graphics);
                    this.pnS = false;
                }
                this.drawClearBar(graphics);
                if (!this.blnClearBarUp) {
                    this.nClearBarMoveY += 2;
                }
                if (this.nClearBarMoveY > 10) {
                    this.blnClearBarUp = true;
                }
                if (!this.blnClearBarUp) break;
                this.nClearBarMoveY -= 2;
                if (this.nClearBarMoveY >= 2) break;
                this.eraseClearBar(graphics);
                this.drawSmallPin(graphics);
                if (!this.blnEndFrame) {
                    this.nPlayStatus = 2;
                } else {
                    this.nPlayStatus = 17;
                    this.dFlag = 0;
                    this.cFlag = 0;
                }
                this.blnClearBarUp = false;
                this.nClearBarMoveY = 0;
                break;
            }
            case 17: {
                this.drawRemainPinsViewer(graphics);
                this.setScore();
                this.DisplayScore(graphics);
                if (this.strike[this.nPlayFrame] == 1) {
                    this.playSound(2);
                } else if (this.spare[this.nPlayFrame] == 1 || this.score1[this.nPlayFrame] != 0 || this.score2[this.nPlayFrame] == 0) {
                    // empty if block
                }
                if (this.strike[this.nPlayFrame] == 1) {
                    ++this.dFlag;
                    if (this.dFlag == 2) {
                        this.dFlag = 0;
                    }
                    this.actionSS(graphics, 0, this.cFlag);
                    ++this.cFlag;
                    if (this.cFlag != 3) break;
                    this.cFlag = 2;
                    break;
                }
                if (this.spare[this.nPlayFrame] == 1) {
                    ++this.dFlag;
                    if (this.dFlag == 2) {
                        this.dFlag = 0;
                    }
                    this.actionSS(graphics, 1, this.cFlag);
                    ++this.cFlag;
                    if (this.cFlag != 2) break;
                    this.cFlag = 1;
                    break;
                }
                if (this.score1[this.nPlayFrame] != 0 || this.score2[this.nPlayFrame] != 0) break;
                ++this.dFlag;
                if (this.dFlag == 2) {
                    this.dFlag = 0;
                }
                this.actionSS(graphics, 2, this.cFlag);
                ++this.cFlag;
                if (this.cFlag != 2) break;
                this.cFlag = 1;
                break;
            }
            case 18: {
                this.drawBackGround(graphics);
                graphics.setColor(0xFFFFFF);
                graphics.setFont(this.FONT_MEDIUM);
            }
        }
    }

    private void initValues() {
        this.nPlayStatus = 0;
        this.nKeyFlag = 0;
        this.nBallThrowCnt = 0;
        this.nClearBarMoveY = 0;
        this.nControlStatus = 0;
        this.nPowerMove = 0;
        this.nPower = 0;
        this.interv = 200;
        this.nSpeed = 0;
        this.nHook = 0;
        this.nFrame = 0;
        this.idx = 0;
        this.nCloseupBallX = 89;
        int n = 0;
        while (n < 11) {
            this.arrPin[n] = 0;
            this.select2Flag[n] = 0;
            this.tempFlag[n] = 0;
            this.temp2Flag[n] = 0;
            this.mx[n] = 0;
            this.my[n] = 0;
            this.mmy[n] = 0;
            this.bm[n] = 4;
            this.prebm[n] = 4;
            this.score1[n] = 0;
            this.score2[n] = 0;
            this.score3[n] = 0;
            this.tscore[n] = 0;
            this.mscore[n] = 0;
            this.lscore[n] = 0;
            this.strike[n] = 0;
            this.spare[n] = 0;
            ++n;
        }
        this.pnS = false;
        this.nCloseupFrame = 0;
        this.nPlayFrame = 0;
        this.nBallX = 64;
        this.bFlag = 0;
        this.gFlag = 1;
        this.dFlag = 0;
        this.cFlag = 0;
        this.ballFlag = 0;
        this.pinSound = 0;
    }

    private void drawBackGround(Graphics graphics) {
        graphics.drawImage(this.IMAGES[2], 0, 0, 20);
    }

    private void drawClearBar(Graphics graphics) {
        this.eraseClearBar(graphics);
        this.drawSmallPin(graphics);
        this.setClipImage(graphics, 68, 19 + this.nClearBarMoveY, this.IMAGES[16], 0, 39, 41, 5);
    }

    private void eraseClearBar(Graphics graphics) {
        this.setClipImage(graphics, 68, 18, this.IMAGES[2], 68, 18, 43, 22);
    }

    private void drawRemainPinsViewer(Graphics graphics) {
        this.setClipImage(graphics, 128, 28, this.IMAGES[16], 0, 0, 41, 33);
        int n = 10;
        while (n >= 1) {
            if (this.arrPin[n] == 0) {
                this.setClipImage(graphics, this.REMAIN_PINS_MARK_X[n], this.REMAIN_PINS_MARK_Y[n], this.IMAGES[16], 36, 34, 5, 5);
            }
            --n;
        }
    }

    private void drawSmallPin(Graphics graphics) {
        boolean bl = false;
        int n = 10;
        while (n >= 1) {
            if (this.arrPin[n] > 0) {
                bl = true;
            }
            --n;
        }
        if (!bl) {
            this.drawSmallPins(graphics);
            this.drawRemainPinsViewer(graphics);
        } else {
            switch (this.nPlayStatus) {
                case 2: {
                    this.drawSmallPins(graphics);
                    this.drawRemainPinsViewer(graphics);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 11: {
                    if (this.nBallThrowCnt == 0 || this.nBallThrowCnt == 2) {
                        this.drawSmallPins(graphics);
                        this.drawRemainPinsViewer(graphics);
                        break;
                    }
                    this.drawSmallPins(graphics);
                    this.drawRemainPinsViewer(graphics);
                    break;
                }
                case 12: {
                    this.drawSmallPins(graphics);
                    this.drawRemainPinsViewer(graphics);
                    break;
                }
                case 13: 
                case 14: {
                    this.drawSmallPins(graphics);
                    this.drawRemainPinsViewer(graphics);
                    break;
                }
                case 15: {
                    this.drawRemainPinsViewer(graphics);
                    break;
                }
            }
        }
    }

    private void setHook(Graphics graphics) {
        this.nHookTemp = this.sbFlag == 0 ? this.nHookTemp + 1 : this.nHookTemp - 1;
        switch (this.nHookTemp) {
            case 0: {
                this.nHook = 3;
                this.sbFlag = 0;
                break;
            }
            case 1: {
                this.nHook = 3;
                break;
            }
            case 2: {
                this.nHook = 2;
                break;
            }
            case 3: {
                this.nHook = 1;
                break;
            }
            case 4: {
                this.nHook = 0;
                break;
            }
            case 5: {
                this.nHook = 0;
                break;
            }
            case 6: {
                this.nHook = -1;
                break;
            }
            case 7: {
                this.nHook = -2;
                break;
            }
            case 8: {
                this.nHook = -3;
                break;
            }
            case 9: {
                this.nHook = -3;
                this.sbFlag = 1;
            }
        }
    }

    private void drawHookGauge(Graphics graphics) {
        this.setClipImage(graphics, this.nBallX - 17, 173, this.IMAGES[11], 0, 36, 28, 9);
        this.setClipImage(graphics, this.nBallX - 17, 184, this.IMAGES[11], 0, 47, 35, 15);
        if (this.nHookTemp >= 0 && this.nHookTemp <= 3) {
            this.drawHookGaugeCircle(graphics, this.nBallX - 12 + this.nHookTemp * 2, 187 + this.nHookTemp, 0);
        } else if (this.nHookTemp == 4) {
            this.drawHookGaugeCircle(graphics, this.nBallX - 12 + this.nHookTemp * 2, 187 + this.nHookTemp - 1, 0);
        } else if (this.nHookTemp == 5) {
            this.drawHookGaugeCircle(graphics, this.nBallX - 12 + this.nHookTemp * 2, 187 + this.nHookTemp - 1, 0);
        } else {
            this.drawHookGaugeCircle(graphics, this.nBallX + 9 - (9 - this.nHookTemp) * 2, 188 + (9 - this.nHookTemp), 0);
        }
    }

    private void setPower(Graphics graphics) {
        this.nSpeed = this.nPower == 1 || this.nPower == 2 ? 16 : (this.nPower == 3 || this.nPower == 4 ? 16 : (this.nPower == 5 || this.nPower == 6 ? 15 : (this.nPower == 7 || this.nPower == 8 ? 15 : (this.nPower == 9 || this.nPower == 10 ? 14 : (this.nPower == 11 || this.nPower == 12 ? 14 : (this.nPower == 13 || this.nPower == 14 ? 13 : 14))))));
    }

    private void drawPowerGauge(Graphics graphics) {
        int n = this.nBallX + 33 > 168 ? this.nBallX - 37 : this.nBallX + 33;
        this.setClipImage(graphics, n - 10, 155, this.IMAGES[11], 31, 14, 9, 31);
        graphics.setColor(0, 0, 0);
        graphics.fillRect(n, 140, 10, 60);
        this.setClipImage(graphics, n, 140 + (15 - this.nPower) * 4 - 2, this.IMAGES[11], 41, 0, 10, 60 - (15 - this.nPower) * 4);
        if (this.nPowerMove != 14) {
            ++this.nPowerMove;
            ++this.nPower;
            this.interv -= 10;
        } else {
            --this.nPower;
            this.interv += 10;
            if (this.nPower == 0) {
                this.nPowerMove = 0;
                this.interv = 200;
            }
        }
    }

    private void drawDirectionArrow(Graphics graphics) {
    }

    public static int getY(int n, int n2, int n3, int n4, int n5) {
        if (n == n3) {
            if (n == n5) {
                return n2;
            }
            return -1;
        }
        if (n3 > n && n5 > n && n5 < n3 || n > n3 && n5 > n3 && n5 < n) {
            return (n5 - n) * (n4 - n2) / (n3 - n) + n2;
        }
        return -1;
    }

    public static int getX(int n, int n2, int n3, int n4, int n5) {
        if (n2 == n4) {
            if (n2 == n5) {
                return n;
            }
            return -2;
        }
        if (n4 > n2 && n5 > n2 && n5 < n4 || n2 > n4 && n5 > n4 && n5 < n2) {
            return (n5 - n2) * (n3 - n) / (n4 - n2) + n;
        }
        return -1;
    }

    private void setSpeedAngle() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        this.nFrame = this.nSpeed;
        if (this.nHook == 0) {
            n5 = 89;
            n6 = -15;
        } else if (this.nHook > 0) {
            switch (this.nBallX) {
                case 156: {
                    n5 = 13;
                    break;
                }
                case 132: {
                    n5 = 16;
                    break;
                }
                case 120: {
                    n5 = 19;
                    break;
                }
                case 108: {
                    n5 = 22;
                    break;
                }
                case 96: {
                    n5 = 25;
                    break;
                }
                case 84: {
                    n5 = 28;
                    break;
                }
                case 72: {
                    n5 = 31;
                    break;
                }
                case 60: {
                    n5 = 34;
                    break;
                }
                case 48: {
                    n5 = 37;
                    break;
                }
                case 36: {
                    n5 = 40;
                    break;
                }
                case 24: {
                    n5 = 13;
                    break;
                }
                default: {
                    n5 = 20;
                }
            }
            n5 += 50;
            n6 = this.nHook * 10 - 3;
        } else if (this.nHook < 0) {
            switch (this.nBallX) {
                case 22: {
                    n5 = 116;
                    break;
                }
                case 46: {
                    n5 = 113;
                    break;
                }
                case 58: {
                    n5 = 110;
                    break;
                }
                case 70: {
                    n5 = 107;
                    break;
                }
                case 82: {
                    n5 = 104;
                    break;
                }
                case 94: {
                    n5 = 101;
                    break;
                }
                case 106: {
                    n5 = 98;
                    break;
                }
                case 118: {
                    n5 = 95;
                    break;
                }
                case 130: {
                    n5 = 92;
                    break;
                }
                case 142: {
                    n5 = 110;
                    break;
                }
                case 154: {
                    n5 = 110;
                    break;
                }
                default: {
                    n5 = 108;
                }
            }
            n5 += 10;
            n6 = -(this.nHook * 10 + 3);
        }
        n7 = this.nBallX;
        this.nGutter = 0;
        if (this.nHook == 0) {
            n8 = 165;
            n = 0;
            while (n <= this.nFrame) {
                this.pRight[n] = 91 + 79 * n / this.nFrame;
                this.pLeft[n] = 91 + -67 * n / this.nFrame;
                ++n;
            }
            n = 0;
            while (n <= this.nFrame) {
                this.moveBall[n][0] = n5 + (n7 - n5) * n / this.nFrame;
                this.moveBall[n][1] = n6 + (n8 - n6) * n / this.nFrame;
                if (this.moveBall[n][0] > this.pRight[n]) {
                    this.moveBall[n][0] = this.pRight[n];
                } else if (this.moveBall[n][0] < this.pLeft[n]) {
                    this.moveBall[n][0] = this.pLeft[n];
                }
                if (this.moveBall[n][1] <= 50) {
                    n3 = this.moveBall[n][0];
                }
                ++n;
            }
        } else {
            n8 = 165 - n6;
            n = 0;
            n2 = this.nFrame;
            while (n <= this.nFrame) {
                if (n5 <= n7) {
                    this.moveBall[n][0] = n5 + (n7 - n5) * n / this.nFrame;
                } else if (n5 > n7) {
                    this.moveBall[n][0] = n5 - (n5 - n7) * n / this.nFrame;
                }
                this.moveBall[n][1] = n6 + n8 * n * (n - n4) / (this.nFrame * (this.nFrame - n4));
                int n9 = BowlingCanvas.getX(2, 0, 84, 208, 208 - this.moveBall[n][1]);
                int n10 = BowlingCanvas.getX(175, 0, 93, 208, 208 - this.moveBall[n][1]);
                if (this.moveBall[n][0] > n10) {
                    if (this.moveBall[n][1] > 40) {
                        this.nGutter = 1;
                    }
                    this.moveBall[n][0] = BowlingCanvas.getX(177, 30, 96, 208, 208 - this.moveBall[n][1]);
                } else if (this.moveBall[n][0] < n9) {
                    if (this.moveBall[n][1] > 40) {
                        this.nGutter = 2;
                    }
                    this.moveBall[n][0] = BowlingCanvas.getX(0, 27, 81, 208, 208 - this.moveBall[n][1]);
                }
                if (this.moveBall[n][1] <= 50) {
                    n3 = this.moveBall[n][0];
                }
                ++n;
                --n2;
            }
        }
        this.nCloseupBallX = (21 * n3 - 640) / 11;
        if (this.nHook > 0) {
            this.nCloseupBallX -= 30;
        } else if (this.nHook == 0) {
            if (this.nBallX < 89) {
                this.nCloseupBallX -= 30;
            } else if (this.nBallX > 89) {
                this.nCloseupBallX -= 10;
            }
        }
        if (this.nGutter == 1) {
            this.nCloseupBallX = 208;
        } else if (this.nGutter == 2) {
            this.nCloseupBallX = 0;
        }
    }

    private void drawMovingBall(Graphics graphics) {
        int n = 0;
        if (164 < this.moveBall[this.nFrame][1]) {
            n = 1;
        } else if (133 < this.moveBall[this.nFrame][1] && this.moveBall[this.nFrame][1] <= 164) {
            n = 2;
        } else if (106 < this.moveBall[this.nFrame][1] && this.moveBall[this.nFrame][1] <= 133) {
            n = 3;
        } else if (83 < this.moveBall[this.nFrame][1] && this.moveBall[this.nFrame][1] <= 106) {
            n = 5;
        } else if (63 < this.moveBall[this.nFrame][1] && this.moveBall[this.nFrame][1] <= 83) {
            n = 7;
        } else if (45 < this.moveBall[this.nFrame][1] && this.moveBall[this.nFrame][1] <= 63) {
            n = 9;
        } else if (29 < this.moveBall[this.nFrame][1] && this.moveBall[this.nFrame][1] <= 45) {
            n = 10;
        } else if (15 < this.moveBall[this.nFrame][1] && this.moveBall[this.nFrame][1] <= 29) {
            n = 10;
        }
        this.setClipImage(graphics, 0, this.moveBall[this.nFrame + 1][1], this.IMAGES[2], 0, this.moveBall[this.nFrame + 1][1], 178, 35);
        this.drawBall(graphics, this.moveBall[this.nFrame][0], this.moveBall[this.nFrame][1], n);
    }

    private void DisplayCloseup(Graphics graphics) {
        graphics.drawImage(this.IMAGES[5], 0, 0, 20);
        this.drawDetailPin(graphics);
    }

    private int getCloseupBallX(int n, int n2, int n3) {
        int n4 = 0;
        if (n3 == 0) {
            return n;
        }
        n4 = n2 > 0 ? n - n2 * 2 : n + n2 * -2;
        return n4;
    }

    private int getGutter(int n, int n2) {
        if (this.nHook == 0 && n < 13) {
            return 0;
        }
        if (n < 13 + n2 * 4) {
            return 1;
        }
        if (n > 164 - n2 * 4) {
            return 2;
        }
        return 0;
    }

    private void drawPin(Graphics graphics) {
        int n = 45;
        block0 : switch (this.getGutter(this.nCloseupBallX, this.nCloseupFrame)) {
            case 1: 
            case 2: {
                int n2 = this.getGutter(this.nCloseupBallX, this.nCloseupFrame) == 1 ? 14 + this.nCloseupFrame * 4 : 160 - this.nCloseupFrame * 4;
                this.drawDarkBall(graphics, n2, n - this.nCloseupFrame * 4, this.nCloseupFrame < 2 ? 1 : 2);
                int n3 = 10;
                while (n3 >= 1) {
                    if (this.arrPin[n3] == 0) {
                        this.drawLargePin(graphics, this.LARGE_PIN_X[n3] + this.mx[n3], this.LARGE_PIN_Y[n3] + this.my[n3], this.bm[n3]);
                    }
                    --n3;
                }
                break;
            }
            default: {
                if (this.nBallThrowCnt == 1) {
                    switch (this.nCloseupFrame) {
                        case 0: 
                        case 1: {
                            int n4 = 10;
                            while (n4 >= 1) {
                                this.drawLargePin(graphics, this.LARGE_PIN_X[n4] + this.mx[n4], this.LARGE_PIN_Y[n4] + this.my[n4], this.bm[n4]);
                                --n4;
                            }
                            this.drawDarkBall(graphics, this.nCloseupBallX - 7, n - this.nCloseupFrame * 4, 1);
                            break;
                        }
                        case 2: 
                        case 3: {
                            int n5 = 10;
                            while (n5 >= 4) {
                                this.drawLargePin(graphics, this.LARGE_PIN_X[n5] + this.mx[n5], this.LARGE_PIN_Y[n5] + this.my[n5], this.bm[n5]);
                                --n5;
                            }
                            this.drawDarkBall(graphics, this.nCloseupBallX - 6, n - this.nCloseupFrame * 4, 2);
                            int n6 = 3;
                            while (n6 >= 1) {
                                this.drawLargePin(graphics, this.LARGE_PIN_X[n6] + this.mx[n6], this.LARGE_PIN_Y[n6] + this.my[n6], this.bm[n6]);
                                --n6;
                            }
                            break block0;
                        }
                        case 4: {
                            this.drawDarkBall(graphics, this.nCloseupBallX - 6, n - this.nCloseupFrame * 4, 3);
                            int n7 = 10;
                            while (n7 >= 1) {
                                this.drawLargePin(graphics, this.LARGE_PIN_X[n7] + this.mx[n7], this.LARGE_PIN_Y[n7] + this.my[n7], this.bm[n7]);
                                --n7;
                            }
                            break block0;
                        }
                        default: {
                            int n8 = 10;
                            while (n8 >= 1) {
                                this.drawLargePin(graphics, this.LARGE_PIN_X[n8] + this.mx[n8], this.LARGE_PIN_Y[n8] + this.my[n8], this.bm[n8]);
                                --n8;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                if (this.nBallThrowCnt != 2) break;
                int n9 = 10;
                while (n9 >= 1) {
                    if (this.select2Flag[n9] == 0) {
                        this.drawLargePin(graphics, this.LARGE_PIN_X[n9] + this.mx[n9], this.LARGE_PIN_Y[n9] + this.my[n9], this.bm[n9]);
                    }
                    --n9;
                }
                this.drawDarkBall(graphics, this.nCloseupBallX - 6, n - this.nCloseupFrame * 4, this.nCloseupFrame < 2 ? 1 : 2);
            }
        }
    }

    private void setRemovedPin(int n, int n2) {
        int n3 = 10;
        int n4 = 0;
        int n5 = 0;
        switch (n2) {
            case 0: {
                n4 = 1;
                n5 = 2;
                break;
            }
            case 1: {
                n4 = 2;
                n5 = 4;
                break;
            }
            case 2: {
                n4 = 4;
                n5 = 7;
                break;
            }
            case 3: {
                n4 = 7;
                n5 = 11;
            }
        }
        int n6 = n4;
        while (n6 < n5) {
            if (n + n3 > this.LARGE_PIN_X[n6] && n - n3 < this.LARGE_PIN_X[n6] + 11) {
                this.arrPin[n6] = n6;
            }
            ++n6;
        }
    }

    private void drawDetailPin(Graphics graphics) {
        this.nCloseupBallX = this.getCloseupBallX(this.nCloseupBallX, this.nHook, this.nCloseupFrame);
        this.setRemovedPin(this.nCloseupBallX, this.nCloseupFrame);
        if (this.nCloseupFrame != 4 && this.nCloseupFrame != 5) {
            this.searchPin();
        }
        this.nextMoveXY(graphics);
    }

    private void searchPin() {
        if (this.nBallThrowCnt == 1) {
            int n = 0;
            while (n <= 10) {
                if (this.tempFlag[n] != 0) {
                    this.arrPin[n] = this.tempFlag[n];
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n <= 10) {
                if (this.temp2Flag[n] != 0) {
                    this.arrPin[n] = this.temp2Flag[n];
                }
                ++n;
            }
        }
    }

    private void nextMoveXY(Graphics graphics) {
        this.pinSound = 0;
        int n = 1;
        while (n <= 10) {
            if (this.nBallThrowCnt == 1) {
                if (this.arrPin[n] != 0) {
                    this.setMoveXY(this.arrPin[n]);
                    this.pinSound = 1;
                    if (this.nCloseupFrame == 5) {
                        this.select2Flag[n] = n;
                    }
                }
            } else if (this.select2Flag[n] == 0 && this.arrPin[n] > 0) {
                this.setMoveXY(this.arrPin[n]);
                this.pinSound = 1;
            }
            ++n;
        }
        this.drawPin(graphics);
    }

    private int getChangePinY(int n) {
        int n2 = 0;
        if (this.prebm[n] == 4) {
            if (this.bm[n] == 3 || this.bm[n] == 5) {
                n2 = 0;
            } else if (this.bm[n] == 2 || this.bm[n] == 6) {
                n2 = Math.abs(this.rnd.nextInt()) % 4 + 2;
            } else if (this.bm[n] == 1 || this.bm[n] == 7) {
                n2 = Math.abs(this.rnd.nextInt()) % 4 + 10;
            } else if (this.bm[n] == 0 || this.bm[n] == 8) {
                n2 = Math.abs(this.rnd.nextInt()) % 4 + 15;
            }
        } else if (this.prebm[n] == 3 || this.prebm[n] == 5) {
            if (this.bm[n] == 2 || this.bm[n] == 6) {
                n2 = Math.abs(this.rnd.nextInt()) % 4 + 2;
            } else if (this.bm[n] == 1 || this.bm[n] == 7) {
                n2 = Math.abs(this.rnd.nextInt()) % 4 + 10;
            } else if (this.bm[n] == 0 || this.bm[n] == 8) {
                n2 = Math.abs(this.rnd.nextInt()) % 4 + 15;
            }
        } else if (this.prebm[n] == 2 || this.prebm[n] == 6) {
            if (this.bm[n] == 1 || this.bm[n] == 7) {
                n2 = Math.abs(this.rnd.nextInt()) % 4 + 5;
            } else if (this.bm[n] == 0 || this.bm[n] == 8) {
                n2 = Math.abs(this.rnd.nextInt()) % 4 + 10;
            }
        } else if (this.prebm[n] == 1 || this.prebm[n] == 7) {
            if (this.bm[n] == 0 || this.bm[n] == 8) {
                n2 = Math.abs(this.rnd.nextInt()) % 4 + 2;
            }
        } else if (this.prebm[n] == 0) {
            n2 = 0;
        }
        return n2;
    }

    private void setMoveXY(int n) {
        int n2 = 0;
        int n3 = 10;
        int n4 = 0;
        int n5 = 7;
        n3 = Math.abs(this.rnd.nextInt()) % 7 + 1;
        n5 = Math.abs(this.rnd.nextInt()) % 7 + 1;
        this.tmp = this.bFlag == 1 ? 0 : -(Math.abs(this.rnd.nextInt()) % 5) + 1;
        if (this.nPlayFrame > 1 && this.strike[this.nPlayFrame - 1] == 1) {
            n3 = Math.abs(this.rnd.nextInt()) % 4 + 1;
            n5 = Math.abs(this.rnd.nextInt()) % 4 + 1;
            this.tmp = -(Math.abs(this.rnd.nextInt()) % 4 + 3);
        }
        if (this.nCloseupBallX < this.LARGE_PIN_X[n] + 5) {
            if (this.prebm[n] == 4 || this.prebm[n] == 3) {
                this.bm[n] = Math.abs(this.rnd.nextInt()) % (this.prebm[n] - 1) + 2;
                this.my[n] = this.my[n] + this.getChangePinY(n);
                this.prebm[n] = this.bm[n] == this.prebm[n] ? this.prebm[n] - 1 : this.bm[n];
            } else {
                this.bm[n] = this.prebm[n] == 0 ? 0 : Math.abs(this.rnd.nextInt()) % this.prebm[n];
                this.my[n] = this.my[n] + this.getChangePinY(n);
                this.prebm[n] = this.bm[n];
            }
            this.mx[n] = this.mx[n] + (Math.abs(this.rnd.nextInt()) % n3 + n2);
        } else {
            if (this.prebm[n] == 4 || this.prebm[n] == 5) {
                this.bm[n] = Math.abs(this.rnd.nextInt()) % (7 - this.prebm[n]) + this.prebm[n];
                this.my[n] = this.my[n] + this.getChangePinY(n);
                this.prebm[n] = this.bm[n] == this.prebm[n] ? this.prebm[n] + 1 : this.bm[n];
            } else {
                this.bm[n] = this.prebm[n] == 8 ? 8 : Math.abs(this.rnd.nextInt()) % (8 - this.prebm[n]) + (this.prebm[n] + 1);
                this.my[n] = this.my[n] + this.getChangePinY(n);
                this.prebm[n] = this.bm[n];
            }
            this.mx[n] = this.mx[n] - (Math.abs(this.rnd.nextInt()) % n3 + n2);
        }
        this.mmy[n] = this.mmy[n] - (Math.abs(this.rnd.nextInt()) % n5 + n4);
        this.searchNextPin(n, this.mx[n], this.mmy[n]);
    }

    private void searchNextPin(int n, int n2, int n3) {
        if (n == 1) {
            if (this.nBallThrowCnt == 1) {
                if (n2 > 0) {
                    this.tempFlag[3] = 3;
                } else {
                    this.tempFlag[2] = 2;
                }
            } else if (n2 > 0) {
                this.temp2Flag[3] = 3;
                if (n3 > 15) {
                    this.temp2Flag[6] = 6;
                }
            } else {
                this.temp2Flag[2] = 2;
                if (n3 > 15) {
                    this.temp2Flag[4] = 4;
                }
            }
        } else if (n == 2) {
            if (this.nBallThrowCnt == 1) {
                if (n3 <= this.tmp) {
                    if (n2 > 0) {
                        this.tempFlag[3] = 3;
                        this.tempFlag[5] = 5;
                    } else {
                        this.tempFlag[4] = 4;
                    }
                } else if (n2 > 0) {
                    this.tempFlag[3] = 3;
                }
            } else if (n3 <= this.tmp) {
                if (n2 > 0) {
                    this.temp2Flag[3] = 3;
                    this.temp2Flag[5] = 5;
                    if (10 < n3 && n3 <= 15) {
                        if (n2 > 10) {
                            this.temp2Flag[6] = 6;
                        }
                    } else if (n3 > 15) {
                        if (n2 > 10) {
                            this.temp2Flag[9] = 9;
                        }
                        if (n2 > 15) {
                            this.temp2Flag[10] = 10;
                        }
                    }
                } else {
                    this.temp2Flag[4] = 4;
                    if (n3 > 15) {
                        this.temp2Flag[7] = 7;
                    }
                }
            } else if (n2 > 0) {
                this.temp2Flag[3] = 3;
            }
        } else if (n == 3) {
            if (this.nBallThrowCnt == 1) {
                if (n3 <= this.tmp) {
                    if (n2 >= 0) {
                        this.tempFlag[6] = 6;
                    } else {
                        this.tempFlag[2] = 2;
                        this.tempFlag[5] = 5;
                    }
                } else if (n2 < 0) {
                    this.tempFlag[2] = 2;
                }
            } else if (n3 <= this.tmp) {
                if (n2 >= 0) {
                    this.temp2Flag[6] = 6;
                    if (n3 > 15) {
                        this.temp2Flag[10] = 10;
                    }
                } else {
                    this.temp2Flag[2] = 2;
                    this.temp2Flag[5] = 5;
                    if (10 < n3 && n3 <= 15) {
                        if (n2 > 10) {
                            this.temp2Flag[4] = 4;
                        }
                    } else if (n3 > 15) {
                        if (n2 > 10) {
                            this.temp2Flag[8] = 8;
                        }
                        if (n2 > 15) {
                            this.temp2Flag[7] = 7;
                        }
                    }
                }
            } else if (n2 < 0) {
                this.temp2Flag[2] = 2;
            }
        } else if (n == 4) {
            if (this.nBallThrowCnt == 1) {
                if (n3 <= this.tmp) {
                    if (n2 > 0) {
                        this.tempFlag[8] = 8;
                    } else {
                        this.tempFlag[7] = 7;
                    }
                } else if (n2 > 5) {
                    this.tempFlag[8] = 8;
                    this.tempFlag[5] = 5;
                }
            } else if (n3 <= this.tmp) {
                if (n2 > 0) {
                    this.temp2Flag[8] = 8;
                    if (n3 > 10) {
                        if (n2 > 10) {
                            this.temp2Flag[9] = 9;
                        }
                        if (n2 > 15) {
                            this.temp2Flag[10] = 10;
                        }
                    }
                } else {
                    this.temp2Flag[7] = 7;
                }
            } else if (n2 > 5) {
                this.temp2Flag[8] = 8;
                this.temp2Flag[5] = 5;
            }
        } else if (n == 5) {
            if (n2 > 0) {
                this.tempFlag[9] = 9;
                if (n2 > 5) {
                    this.tempFlag[6] = 6;
                }
            } else {
                this.tempFlag[8] = 8;
                if (n2 < -5) {
                    this.tempFlag[4] = 4;
                }
            }
        } else if (n == 6) {
            if (this.nBallThrowCnt == 1) {
                if (n3 < this.tmp) {
                    if (n2 >= 0) {
                        this.tempFlag[10] = 10;
                    } else {
                        this.tempFlag[9] = 9;
                    }
                } else if (n2 < -5) {
                    this.tempFlag[5] = 5;
                    this.tempFlag[9] = 9;
                }
            } else if (n3 < this.tmp) {
                if (n2 >= 0) {
                    this.temp2Flag[10] = 10;
                } else {
                    this.temp2Flag[9] = 9;
                    if (n3 > 10) {
                        if (n2 > 10) {
                            this.temp2Flag[8] = 8;
                        }
                        if (n2 > 15) {
                            this.temp2Flag[7] = 7;
                        }
                    }
                }
            } else if (n2 < -5) {
                this.temp2Flag[5] = 5;
                this.temp2Flag[9] = 9;
            }
        } else if (n == 7) {
            if (this.nBallThrowCnt == 1) {
                if (n2 > 7) {
                    this.tempFlag[8] = 8;
                }
            } else if (n2 > 7) {
                this.temp2Flag[8] = 8;
            }
        } else if (n == 8) {
            if (this.nBallThrowCnt == 1) {
                if (n2 > 7) {
                    this.tempFlag[9] = 9;
                } else if (n2 < -7) {
                    this.tempFlag[7] = 7;
                }
            } else if (n2 > 7) {
                this.temp2Flag[9] = 9;
            } else if (n2 < -7) {
                this.temp2Flag[7] = 7;
            }
        } else if (n == 9) {
            if (this.nBallThrowCnt == 1) {
                if (n2 > 7) {
                    this.tempFlag[10] = 10;
                } else if (n2 < -7) {
                    this.tempFlag[8] = 8;
                }
            } else if (n2 > 7) {
                this.temp2Flag[10] = 10;
            } else if (n2 < -7) {
                this.temp2Flag[8] = 8;
            }
        } else if (n == 10) {
            if (this.nBallThrowCnt == 1) {
                if (n2 < -7) {
                    this.tempFlag[9] = 9;
                }
            } else if (n2 < -7) {
                this.temp2Flag[9] = 9;
            }
        }
    }

    private void firstScore() {
        int n = 0;
        int n2 = 10;
        while (n2 >= 1) {
            if (this.arrPin[n2] > 0) {
                ++n;
            }
            --n2;
        }
        if (n == 10) {
            this.strike[this.nPlayFrame] = 1;
        }
        this.score1[this.nPlayFrame] = n;
    }

    private void secondScore() {
        int n = 0;
        int n2 = 10;
        while (n2 >= 1) {
            if (this.arrPin[n2] > 0) {
                ++n;
            }
            --n2;
        }
        if (n == 10) {
            this.spare[this.nPlayFrame] = 1;
        }
        this.score2[this.nPlayFrame] = n - this.score1[this.nPlayFrame];
    }

    private void setScore() {
        int n = 0;
        while (n <= this.nPlayFrame) {
            this.tscore[n] = this.score1[n] + this.score2[n];
            if (n == 0) {
                this.mscore[n] = 0 + this.tscore[n];
            } else if (1 <= n && n <= 8) {
                if (this.strike[n] == 1) {
                    if (this.strike[n - 1] == 1) {
                        if (n >= 2) {
                            if (this.strike[n - 2] == 1) {
                                this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1] + this.tscore[n];
                            } else if (this.spare[n - 2] == 1) {
                                this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1];
                            }
                            this.mscore[n - 1] = this.lscore[n - 2] + this.tscore[n - 1];
                        }
                        this.lscore[n - 1] = this.mscore[n - 1] + this.tscore[n];
                        this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                    } else if (this.spare[n - 1] == 1) {
                        if (n >= 2) {
                            if (this.strike[n - 2] == 1) {
                                this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1];
                            } else if (this.spare[n - 2] == 1) {
                                this.lscore[n - 2] = this.mscore[n - 2] + this.score1[n - 1];
                            }
                            this.mscore[n - 1] = this.lscore[n - 2] + this.tscore[n - 1];
                        }
                        this.lscore[n - 1] = this.mscore[n - 1] + this.tscore[n];
                        this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                    } else {
                        this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                    }
                } else if (this.spare[n] == 1) {
                    if (this.strike[n - 1] == 1) {
                        if (n >= 2) {
                            if (this.strike[n - 2] == 1) {
                                this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1] + this.score1[n];
                            } else if (this.spare[n - 2] == 1) {
                                this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1];
                            }
                            this.mscore[n - 1] = this.lscore[n - 2] + this.tscore[n - 1];
                        }
                        this.lscore[n - 1] = this.mscore[n - 1] + this.tscore[n];
                        this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                    } else if (this.spare[n - 1] == 1) {
                        if (n >= 2) {
                            if (this.strike[n - 2] == 1) {
                                this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1];
                            } else if (this.spare[n - 2] == 1) {
                                this.lscore[n - 2] = this.mscore[n - 2] + this.score1[n - 1];
                            }
                            this.mscore[n - 1] = this.lscore[n - 2] + this.tscore[n - 1];
                        }
                        this.lscore[n - 1] = this.mscore[n - 1] + this.score1[n];
                        this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                    } else {
                        this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                    }
                } else if (this.strike[n - 1] == 1) {
                    if (n >= 2) {
                        if (this.strike[n - 2] == 1) {
                            this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1] + this.score1[n];
                        } else if (this.spare[n - 2] == 1) {
                            this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1];
                        }
                    }
                    this.lscore[n - 1] = this.mscore[n - 1] + this.tscore[n];
                    this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                    this.lscore[n] = this.mscore[n];
                } else if (this.spare[n - 1] == 1) {
                    if (n >= 2) {
                        if (this.strike[n - 2] == 1) {
                            this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1];
                        } else if (this.spare[n - 2] == 1) {
                            this.lscore[n - 2] = this.mscore[n - 2] + this.score1[n - 1];
                        }
                        this.mscore[n - 1] = this.lscore[n - 2] + this.tscore[n - 1];
                    }
                    this.lscore[n - 1] = this.mscore[n - 1] + this.score1[n];
                    this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                    this.lscore[n] = this.mscore[n];
                } else {
                    this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                    this.lscore[n] = this.mscore[n];
                }
            } else if (n == 9) {
                this.tscore[n] = this.score1[n] + this.score2[n] + this.score3[n];
                if (this.strike[n - 1] == 1) {
                    if (this.strike[n - 2] == 1) {
                        this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1] + this.score1[n];
                    } else if (this.spare[n - 2] == 1) {
                        this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1];
                    }
                    this.mscore[n - 1] = this.lscore[n - 2] + this.tscore[n - 1];
                    this.lscore[n - 1] = this.mscore[n - 1] + this.score1[n] + this.score2[n];
                    this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                } else if (this.spare[n - 1] == 1) {
                    if (this.strike[n - 2] == 1) {
                        this.lscore[n - 2] = this.mscore[n - 2] + this.tscore[n - 1];
                    } else if (this.spare[n - 2] == 1) {
                        this.lscore[n - 2] = this.mscore[n - 2] + this.score1[n - 1];
                    }
                    this.mscore[n - 1] = this.lscore[n - 2] + this.tscore[n - 1];
                    this.lscore[n - 1] = this.mscore[n - 1] + this.score1[n];
                    this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                } else {
                    this.mscore[n] = this.lscore[n - 1] + this.tscore[n];
                }
                this.lscore[n] = this.mscore[n];
                this.nScore = this.lscore[n];
            }
            ++n;
        }
    }

    private void drawScoreRect(Graphics graphics) {
        int n = 0;
        int n2 = 135;
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(n, n2, 178, n2);
        graphics.drawLine(n, n2 + 52, 178, n2 + 52);
        int n3 = 0;
        int n4 = 0;
        while (n3 < 10) {
            if (n4 > 4) {
                n4 = 0;
                n2 += 27;
            }
            if (n3 == 9) {
                graphics.drawRect(n + 27 + n4 * 25, n2, 38, 25);
                graphics.drawRect(n + 39 + n4 * 25, n2, 13, 13);
                graphics.drawRect(n + 39 + n4 * 25 + 13, n2, 13, 13);
            } else {
                graphics.drawRect(n + 27 + n4 * 25, n2, 25, 25);
                graphics.drawRect(n + 39 + n4 * 25, n2, 13, 13);
            }
            ++n3;
            ++n4;
        }
    }

    private void DisplayScore(Graphics graphics) {
        int n = 0;
        int n2 = 40;
        int n3 = 0;
        int n4 = 137;
        int n5 = 31;
        graphics.setFont(this.FONT_SMALL);
        n3 = 130;
        this.setClipImage(graphics, 0, 96, this.IMAGES[6], 0, 0, 178, 112);
        this.drawScoreRect(graphics);
        graphics.setColor(0xFFFFFF);
        int n6 = 0;
        boolean bl = false;
        n6 = 0;
        while (n6 <= this.nPlayFrame) {
            if (n6 != 9) {
                if (this.strike[n6] == 1) {
                    this.drawScoreNumber(graphics, n6 < 5 ? n5 + 10 + n6 * 25 : n5 + 10 + (n6 - 5) * 25, n6 < 5 ? n4 : n4 + 27, -2);
                } else if (this.spare[n6] == 1) {
                    this.drawScoreNumber(graphics, n6 < 5 ? n5 + 10 + n6 * 25 : n5 + 10 + (n6 - 5) * 25, n6 < 5 ? n4 : n4 + 27, -1);
                } else {
                    if (this.score1[n6] != 0) {
                        this.drawScoreNumber(graphics, n6 < 5 ? n5 + n6 * 25 : n5 + (n6 - 5) * 25, n6 < 5 ? n4 : n4 + 27, this.score1[n6]);
                    } else {
                        this.drawScoreNumber(graphics, n6 < 5 ? n5 - 3 + n6 * 25 : n5 - 3 + (n6 - 5) * 25, n6 < 5 ? n4 : n4 + 27, -3);
                    }
                    if (this.score2[n6] != 0) {
                        this.drawScoreNumber(graphics, n6 < 5 ? n5 + 13 + n6 * 25 : n5 + 13 + (n6 - 5) * 25, n6 < 5 ? n4 : n4 + 27, this.score2[n6]);
                    } else {
                        this.drawScoreNumber(graphics, n6 < 5 ? n5 + 10 + n6 * 25 : n5 + 10 + (n6 - 5) * 25, n6 < 5 ? n4 : n4 + 27, -3);
                    }
                }
            } else {
                if (this.score1[n6] == 10 || this.score1[n6] == 0) {
                    this.drawScoreNumber(graphics, n5 + 97, n4 + 27, n6 == 10 ? -2 : -3);
                } else {
                    this.drawScoreNumber(graphics, n5 + 100, n4 + 27, this.score1[n6]);
                }
                if (this.score2[n6] == 10 || this.score2[n6] == 0) {
                    this.drawScoreNumber(graphics, n5 + 110, n4 + 27, n6 == 10 ? -2 : -3);
                } else {
                    this.drawScoreNumber(graphics, n5 + 113, n4 + 27, this.score2[n6]);
                }
                if (this.score3[n6] == 10 || this.score3[n6] == 0) {
                    this.drawScoreNumber(graphics, n5 + 123, n4 + 27, n6 == 10 ? -2 : -3);
                } else {
                    this.drawScoreNumber(graphics, n5 + 126, n4 + 27, this.score3[n6]);
                }
            }
            if (this.strike[n6] == 0) {
                if (this.strike[n6] == 0 && this.spare[n6] == 0) {
                    if (n6 == 0) {
                        this.lscore[n6] = this.mscore[n6];
                    }
                    this.drawScoreNumbers(graphics, n6 < 5 ? n5 - 3 + n6 * 25 : n5 - 3 + (n6 - 5) * 25, n6 < 5 ? n4 + 12 : n4 + 39, this.lscore[n6]);
                }
                if (n6 > 0 && (this.spare[n6 - 1] == 1 || this.strike[n6 - 1] == 1)) {
                    n = n6 - 1;
                    this.drawScoreNumbers(graphics, n < 5 ? n5 - 3 + n * 25 : n5 - 3 + (n - 5) * 25, n < 5 ? n4 + 12 : n4 + 39, this.lscore[n]);
                    if (n6 > 1 && this.strike[n6 - 1] == 1 && this.strike[n6 - 2] == 1) {
                        n = n6 - 2;
                        this.drawScoreNumbers(graphics, n < 5 ? n5 - 3 + n * 25 : n5 - 3 + (n - 5) * 25, n < 5 ? n4 + 12 : n4 + 39, this.lscore[n]);
                    }
                }
            } else if (this.strike[n6] == 1 && n6 > 0 && this.spare[n6 - 1] == 1) {
                n = n6 - 1;
                this.drawScoreNumbers(graphics, n < 5 ? n5 - 3 + n * 25 : n5 - 3 + (n - 5) * 25, n < 5 ? n4 + 12 : n4 + 39, this.lscore[n]);
                if (n6 > 1 && this.strike[n6 - 1] == 1 && this.strike[n6 - 2] == 1) {
                    n = n6 - 2;
                    this.drawScoreNumbers(graphics, n < 5 ? n5 - 3 + n * 25 : n5 - 3 + (n - 5) * 25, n < 5 ? n4 + 12 : n4 + 39, this.lscore[n]);
                }
            }
            ++n6;
        }
    }

    private void drawScoreNumber(Graphics graphics, int n, int n2, int n3) {
        if (n3 >= 1 && n3 <= 9) {
            this.setClipImage(graphics, n, n2, this.IMAGES[17], (n3 - 1) * 5, 0, 5, 11);
        } else if (n3 == 0) {
            this.setClipImage(graphics, n, n2, this.IMAGES[17], 45, 0, 5, 11);
        } else if (n3 == -1) {
            this.setClipImage(graphics, n, n2, this.IMAGES[17], 50, 0, 11, 11);
        } else if (n3 == -2) {
            this.setClipImage(graphics, n, n2, this.IMAGES[17], 61, 0, 11, 11);
        } else if (n3 == -3) {
            this.setClipImage(graphics, n, n2, this.IMAGES[17], 72, 0, 11, 11);
        }
    }

    private void drawScoreNumbers(Graphics graphics, int n, int n2, int n3) {
        String string = String.valueOf(n3);
        n += (3 - string.length()) * 7;
        int n4 = 0;
        while (n4 < string.length()) {
            this.drawScoreNumber(graphics, n + n4 * 7, n2, string.charAt(n4) - 48);
            ++n4;
        }
    }

    private void actionSS(Graphics graphics, int n, int n2) {
        if (n == 0) {
            graphics.drawImage(this.IMAGES[14], 9, 75, 20);
            this.drawCharacter(graphics, 89, 116, 6 + n2);
        } else if (n == 1) {
            graphics.drawImage(this.IMAGES[15], 17, 75, 20);
            this.drawCharacter(graphics, 89, 116, 9 + n2);
        } else if (n == 2 && n2 < 2) {
            this.drawCharacter(graphics, 89, 116, 11 + n2);
        }
    }
}

