/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class TitleCanvas
extends FullCanvas
implements CommandListener {
    Image titleImg;
    Image bufImg;
    Image copyImg;
    GameMain gameMain;
    Graphics bufg;
    Form about;
    Form contact;
    Form keymap;
    List menuList;
    Font font;
    String[] arrayStr = new String[]{"Start Game", "Sound", "High Scores", "About", "Key Map", "Contact Us", "Exit"};
    Command backCmd = new Command("Back", 2, 1);
    Command okCmd = new Command("OK", 2, 1);
    Command cancelCmd = new Command("Cancel", 3, 1);
    private final NokiaGameEffects gameEffects;
    short height;
    short width;
    short v;
    short w;
    boolean keyFlag;

    public TitleCanvas(GameMain gameMain) {
        this.gameMain = gameMain;
        this.height = (short)208;
        this.width = (short)176;
        this.bufImg = Image.createImage((int)this.width, (int)this.height);
        this.bufg = this.bufImg.getGraphics();
        this.gameEffects = new NokiaGameEffects(gameMain);
        try {
            this.titleImg = Image.createImage((String)"/img/title.png");
            this.copyImg = Image.createImage((String)"/img/menu/copy.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.menuList = new List("Menu", 3);
        if (gameMain.resumeFlag) {
            this.menuList.append("Continue", null);
        } else {
            this.menuList.append("Start Game", null);
        }
        if (gameMain.soundFlag) {
            this.menuList.append("Sound : ON", null);
        } else {
            this.menuList.append("Sound : OFF", null);
        }
        this.menuList.append("High Scores", null);
        this.menuList.append("About", null);
        this.menuList.append("Key Map", null);
        this.menuList.append("Contact Us", null);
        this.menuList.append("Exit", null);
        this.menuList.addCommand(this.backCmd);
        this.menuList.setCommandListener((CommandListener)this);
    }

    protected void keyPressed(int n) {
        if (n == -5 || n == 53) {
            this.gameMain.display.setCurrent((Displayable)this.menuList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            if (displayable != this.menuList) return;
            switch (this.menuList.getSelectedIndex()) {
                case 0: {
                    if (!this.gameMain.resumeFlag) {
                        this.gameMain.gameFlag = 0;
                        this.gameMain.loading = new Loading(this.gameMain);
                        this.gameMain.timer.schedule((TimerTask)this.gameMain.loading, 0L, 20L);
                        this.gameMain.display.setCurrent((Displayable)this.gameMain.titleCanvas);
                        return;
                    } else {
                        this.gameMain.gameFlag = 0;
                        this.gameMain.display.setCurrent((Displayable)this.gameMain.gameCanvas);
                        this.gameMain.titleCanvas = null;
                    }
                    return;
                }
                case 1: {
                    this.menuList = null;
                    this.menuList = new List("Menu", 3);
                    if (this.gameMain.resumeFlag) {
                        this.menuList.append("Continue", null);
                    } else {
                        this.menuList.append("Start Game", null);
                    }
                    if (this.gameMain.soundFlag) {
                        this.gameMain.soundFlag = false;
                        this.menuList.append("Sound : OFF", null);
                    } else {
                        this.gameMain.soundFlag = true;
                        this.menuList.append("Sound : ON", null);
                    }
                    this.menuList.append("High Scores", null);
                    this.menuList.append("About", null);
                    this.menuList.append("Key Map", null);
                    this.menuList.append("Contact Us", null);
                    this.menuList.append("Exit", null);
                    this.menuList.addCommand(this.backCmd);
                    this.menuList.setCommandListener((CommandListener)this);
                    this.menuList.setSelectedIndex(1, true);
                    this.gameMain.display.setCurrent((Displayable)this.gameMain.titleCanvas.menuList);
                    return;
                }
                case 2: {
                    if (this.gameMain.scoreBoard == null) {
                        this.gameMain.scoreBoard = new ScoreBoard(this.gameMain);
                    }
                    this.gameMain.display.setCurrent((Displayable)this.gameMain.scoreBoard);
                    return;
                }
                case 3: {
                    if (this.about == null) {
                        this.about = new Form("About");
                        this.about.append("Boobi Sisters\n1.0.0\nBoobie sisters went to farm for their experience. Their mission is to gather their cattle in a pen. They should get their cattle and drive them in the pen which they should enter.\nBecause they can't deal with three animals simultaneously, when you get the other animal you must throw it away.\nIf you don't complete successfully, your life will reduce.");
                        this.about.addCommand(this.backCmd);
                        this.about.setCommandListener((CommandListener)this);
                    }
                    this.gameMain.display.setCurrent((Displayable)this.about);
                    return;
                }
                case 4: {
                    if (this.keymap == null) {
                        this.keymap = new Form("Key Map");
                        this.keymap.append("Left : 4 or LEFT\nRight : 6 or RIGHT\nThrow animal : 5 or OK\nDrive animal in upper pen : 1 or UP\nDrive animal in downer pen : 7 or DOWN");
                        this.keymap.addCommand(this.backCmd);
                        this.keymap.setCommandListener((CommandListener)this);
                    }
                    this.gameMain.display.setCurrent((Displayable)this.keymap);
                    return;
                }
                case 5: {
                    if (this.contact == null) {
                        this.contact = new Form("Contact");
                        this.contact.append(this.copyImg);
                        this.contact.addCommand(this.backCmd);
                        this.contact.setCommandListener((CommandListener)this);
                    }
                    this.gameMain.display.setCurrent((Displayable)this.contact);
                    return;
                }
                case 6: {
                    this.gameMain.midlet.destroyApp(true);
                    this.gameMain.midlet.notifyDestroyed();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (command != this.backCmd) return;
        if (displayable == this.menuList) {
            this.gameMain.display.setCurrent((Displayable)this.gameMain.titleCanvas);
            return;
        } else {
            this.gameMain.display.setCurrent((Displayable)this.menuList);
        }
    }

    public void paint(Graphics graphics) {
        if (this.keyFlag) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, (int)this.width, (int)this.height);
        } else if (this.gameMain.loading != null) {
            graphics.drawImage(this.bufImg, 0, 0, 0x10 | 4);
        } else {
            graphics.drawImage(this.titleImg, 0, 0, 4 | 0x10);
        }
    }

    void bufPaint() {
        this.v = (short)(this.v + 1);
        this.w = (short)(this.w + 1);
        this.bufg.setColor(254, 255, 255);
        this.bufg.fillRect(0, 0, (int)this.width, (int)this.height);
        if (this.v < this.width / 2 && this.w < this.height / 2) {
            this.bufg.setClip((int)this.v, (int)this.w, this.width - this.v * 2, this.height - this.w * 2);
            this.bufg.drawImage(this.titleImg, 0, 0, 0x10 | 4);
        } else {
            this.bufg.setFont(Font.getFont((int)0, (int)0, (int)8));
            this.bufg.setClip(0, 0, (int)this.width, (int)this.height);
            this.bufg.setColor(0, 0, 0);
            this.bufg.drawString("Loading", this.width / 2, this.height / 2, 33);
            this.bufg.drawString("Please Wait...", this.width / 2, this.height / 2, 17);
            ++this.gameMain.loadingCount;
        }
        this.repaint();
        this.serviceRepaints();
    }
}

