/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Timer;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GameMain {
    public static final short START = 0;
    public static final short EXIT = 1;
    public static final short MENUVIEW = 2;
    public static final short INIT = 3;
    public static final short PAUSE = 4;
    public static final short NEXT = 5;
    public static final short MAX_SCORE = 10;
    Display display;
    RecordStore rec;
    GameMIDlet midlet;
    NokiaGameEffects effects = new NokiaGameEffects(this);
    GameImageLoader gameImg;
    TitleCanvas titleCanvas;
    GameTimer gameTimer;
    GameCanvas gameCanvas;
    ScoreBoard scoreBoard;
    Loading loading;
    Timer timer;
    int[] stageScoreBoard;
    int gameFlag;
    int totalScore;
    int[] nScore = new int[10];
    int loadingCount;
    int screenSize;
    boolean resumeFlag;
    boolean soundFlag;
    int rank;
    int[] score = new int[16];

    public GameMain(Display display, GameMIDlet gameMIDlet) {
        this.display = display;
        this.midlet = gameMIDlet;
        this.soundFlag = true;
        this.timer = new Timer();
    }

    public void scoreCal() {
        if (this.totalScore >= this.nScore[9]) {
            this.nScore[9] = this.totalScore;
            this.rank = 9;
            while (this.nScore[this.rank - 1] <= this.nScore[this.rank]) {
                int n = this.nScore[this.rank - 1];
                this.nScore[this.rank - 1] = this.nScore[this.rank];
                this.nScore[this.rank] = n;
                --this.rank;
                if (this.rank <= 0) break;
            }
            ++this.rank;
        } else {
            this.rank = 0;
        }
    }

    private void openRMS() {
        try {
            if (this.rec == null) {
                this.rec = RecordStore.openRecordStore((String)"RacingDB", (boolean)true);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void readRMS() {
        try {
            if (this.rec.getNumRecords() == 0) {
                int n = 0;
                while (n < 10) {
                    this.nScore[n] = 0;
                    ++n;
                }
                this.soundFlag = true;
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rec.getRecord(1));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    int n = 0;
                    while (n < 10) {
                        this.nScore[n] = dataInputStream.readInt();
                        ++n;
                    }
                    this.soundFlag = dataInputStream.readBoolean();
                }
                catch (IOException iOException) {}
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    void saveRMS() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n = 0;
            while (n < 10) {
                dataOutputStream.writeInt(this.nScore[n]);
                ++n;
            }
            dataOutputStream.writeBoolean(this.soundFlag);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            if (this.rec.getNumRecords() == 0) {
                this.rec.addRecord(byArray, 0, byArray.length);
            } else {
                this.rec.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void closeRMS() {
        try {
            if (this.rec != null) {
                this.rec.closeRecordStore();
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void gameControl() {
        switch (this.gameFlag) {
            case 3: {
                this.openRMS();
                this.readRMS();
                if (this.titleCanvas == null) {
                    this.titleCanvas = new TitleCanvas(this);
                }
                this.display.setCurrent((Displayable)this.titleCanvas);
                this.effects.resume();
                this.effects.eachSound(14);
                break;
            }
            case 1: {
                if (this.gameCanvas != null) {
                    this.gameCanvas = null;
                }
                System.gc();
                this.saveRMS();
                this.closeRMS();
                this.midlet.destroyApp(true);
                this.midlet.notifyDestroyed();
            }
        }
    }
}

